/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.LocalResources;
import at.ipsquare.commons.core.util.PerformanceLogFormatter;
import at.ipsquare.commons.core.util.PerformanceLogger;
import at.ipsquare.commons.core.util.UnitTestAppender;
import at.ipsquare.commons.core.util.UnitTestPeformanceLogFormatter;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class TestPerformanceLoggerWithoutSettingsFile {
    @BeforeClass
    public static void beforeClass() {
        try {
            File file = LocalResources.getFile((String)"at/ipsquare/commons/core/util/performanceLogger.xml");
            if (!file.delete()) {
                throw new RuntimeException("Could not delete '" + file + "'.");
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        UnitTestAppender.reset();
        PerformanceLogger.reloadDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws InterruptedException {
        final PerformanceLogger plog = new PerformanceLogger();
        Thread.sleep(1L);
        plog.logElapsed();
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)TestPerformanceLoggerWithoutSettingsFile.class.getSimpleName()));
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"test"));
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"***UnitTest***|")));
        new InnerClass(plog);
        plog.logElapsed("asdf");
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"asdf"));
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)InnerClass.class.getSimpleName()));
        new Object(){
            {
                plog.logElapsedAndRestart("obj");
            }

            void strangeConstructIndeed() {
                plog.logElapsed("strange");
            }
        }.strangeConstructIndeed();
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"obj"));
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"strangeConstructIndeed"));
        new Runnable(){

            @Override
            public void run() {
                plog.logElapsed("running away");
            }
        }.run();
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"running"));
        PerformanceLogger plog2 = new PerformanceLogger(1000L);
        plog2.logElapsed("should-never-be-logged");
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"should-never-be-logged")));
        Thread.sleep(1500L);
        plog2.logElapsed("should-be-logged");
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"should-be-logged"));
        plog2 = new PerformanceLogger((PerformanceLogFormatter)new UnitTestPeformanceLogFormatter());
        plog2.logElapsed();
        Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.containsString((String)"***UnitTest***|"));
        Logger logbackLogger = (Logger)LoggerFactory.getLogger(PerformanceLogger.class);
        try {
            logbackLogger.setLevel(Level.ERROR);
            plog.logElapsedAndRestart("do-not-log-me");
            Assert.assertThat((Object)TestPerformanceLoggerWithoutSettingsFile.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"do-not-log-me")));
        }
        finally {
            logbackLogger.setLevel(Level.DEBUG);
        }
    }

    private static String logString() {
        return UnitTestAppender.logString();
    }

    private static class InnerClass {
        InnerClass(final PerformanceLogger plog) throws InterruptedException {
            plog.restart();
            class InCtorClass {
                InCtorClass() {
                    plog.logElapsedAndRestart();
                }
            }
            new InCtorClass();
            new InnerInnerClass().doStuff();
        }

        static class InnerInnerClass {
            InnerInnerClass() {
            }

            void doStuff() throws InterruptedException {
                PerformanceLogger plog = new PerformanceLogger();
                Thread.sleep(5L);
                plog.logElapsed("done, bastards");
            }
        }
    }
}

