/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.util;

import at.ipsquare.commons.core.util.PerformanceLogger;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.OutputStreamAppender;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class TestPerformanceLogger {
    private static String logString() {
        try {
            return TestAppender.stream.toString("UTF-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void test() throws InterruptedException {
        final PerformanceLogger plog = new PerformanceLogger();
        Thread.sleep(1L);
        plog.logElapsed();
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)TestPerformanceLogger.class.getSimpleName()));
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)"test"));
        new InnerClass(plog);
        plog.logElapsed("asdf");
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)"asdf"));
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)InnerClass.class.getSimpleName()));
        new Object(){
            {
                plog.logElapsedAndRestart("obj");
            }

            void strangeConstructIndeed() {
                plog.logElapsed("strange");
            }
        }.strangeConstructIndeed();
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)"obj"));
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)"strangeConstructIndeed"));
        new Runnable(){

            @Override
            public void run() {
                plog.logElapsed("running away");
            }
        }.run();
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)"running"));
        PerformanceLogger plog2 = new PerformanceLogger(1000L);
        plog2.logElapsed("should-never-be-logged");
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"should-never-be-logged")));
        Thread.sleep(1500L);
        plog2.logElapsed("should-be-logged");
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.containsString((String)"should-be-logged"));
        Logger logbackLogger = (Logger)LoggerFactory.getLogger(PerformanceLogger.class);
        logbackLogger.setLevel(Level.ERROR);
        plog.logElapsedAndRestart("do-not-log-me");
        Assert.assertThat((Object)TestPerformanceLogger.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"do-not-log-me")));
    }

    private static class InnerClass {
        InnerClass(final PerformanceLogger plog) throws InterruptedException {
            plog.restart();
            class InCtorClass {
                InCtorClass() {
                    plog.logElapsedAndRestart();
                }
            }
            new InCtorClass();
            new InnerInnerClass().doStuff();
        }

        static class InnerInnerClass {
            InnerInnerClass() {
            }

            void doStuff() throws InterruptedException {
                PerformanceLogger plog = new PerformanceLogger();
                Thread.sleep(5L);
                plog.logElapsed("done, bastards");
            }
        }
    }

    public static class TestAppender<E>
    extends OutputStreamAppender<E> {
        private static final ByteArrayOutputStream stream = new ByteArrayOutputStream();

        public void start() {
            this.setOutputStream(stream);
            super.start();
        }
    }
}

