/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal.parser;

import at.gridgears.held.AmlData;
import at.gridgears.held.Location;
import at.gridgears.held.internal.parser.AmlDataParser;
import at.gridgears.held.internal.parser.ParseUtils;
import at.gridgears.schemas.held.AmlType;
import at.gridgears.schemas.held.CircleType;
import at.gridgears.schemas.held.Geopriv;
import at.gridgears.schemas.held.LocInfoType;
import at.gridgears.schemas.held.LocationResponseType;
import at.gridgears.schemas.held.PointType;
import at.gridgears.schemas.held.Presence;
import at.gridgears.schemas.held.Status;
import at.gridgears.schemas.held.Tuple;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.mutable.MutableObject;

final class LocationParser {
    private final AmlDataParser amlDataParser = new AmlDataParser();

    LocationParser() {
    }

    List<Location> parse(LocationResponseType locationResponseType) {
        MutableObject timestamp = new MutableObject();
        MutableObject amlData = new MutableObject();
        LinkedList<Location> result = new LinkedList<Location>();
        ParseUtils.getValue(locationResponseType.getAny(), Presence.class).map(Presence::getTuple).map(ParseUtils::first).map(this.storeTimestamp((MutableObject<Instant>)timestamp)).map(this.storeAml((MutableObject<AmlData>)amlData)).map(Tuple::getStatus).map(Status::getAny).map(ParseUtils::first).map(LocationParser::getGeopriv).ifPresent(geopriv -> result.addAll(this.parseLocation((Geopriv)geopriv, (Instant)timestamp.getValue(), (AmlData)amlData.getValue())));
        return result;
    }

    private List<Location> parseLocation(Geopriv geopriv, Instant timestamp, AmlData amlData) {
        LinkedList<Location> result = new LinkedList<Location>();
        LocInfoType locationInfo = geopriv.getLocationInfo();
        if (locationInfo != null) {
            result.addAll(this.parseLocations(locationInfo.getAny(), timestamp, amlData));
        }
        return result;
    }

    private List<Location> parseLocations(List<Object> locations, Instant timestamp, @Nullable AmlData amlData) {
        LinkedList<Location> result = new LinkedList<Location>();
        locations.forEach(location -> {
            Optional<PointType> pointTypeOptional = ParseUtils.getValue(location, PointType.class);
            if (pointTypeOptional.isPresent()) {
                pointTypeOptional.ifPresent(point -> result.add(this.getLocation(timestamp, amlData, (PointType)point)));
            } else {
                Optional<CircleType> circleTypeOptional = ParseUtils.getValue(location, CircleType.class);
                circleTypeOptional.ifPresent(circle -> result.add(this.getLocation(timestamp, amlData, (CircleType)circle)));
            }
        });
        return result;
    }

    private Function<Tuple, Tuple> storeTimestamp(MutableObject<Instant> timestamp) {
        return tuple -> {
            timestamp.setValue((Object)this.getTimestamp((Tuple)tuple));
            return tuple;
        };
    }

    private Function<Tuple, Tuple> storeAml(MutableObject<AmlData> amlData) {
        return tuple -> {
            Optional<AmlType> amlType = ParseUtils.getValue(tuple.getAny(), AmlType.class);
            amlType.ifPresent(aml -> amlData.setValue((Object)this.amlDataParser.parseAmlData((AmlType)aml)));
            return tuple;
        };
    }

    private Instant getTimestamp(Tuple tuple) {
        XMLGregorianCalendar tupleTimestamp = tuple.getTimestamp();
        return ParseUtils.toInstant(tupleTimestamp);
    }

    private static Geopriv getGeopriv(Object object) {
        return ParseUtils.getValue(object, Geopriv.class).get();
    }

    private Location getLocation(Instant timestamp, @Nullable AmlData amlData, PointType point) {
        List coordinates = point.getPos().getValue();
        return new Location(Double.valueOf((String)coordinates.get(0)), Double.valueOf((String)coordinates.get(1)), 0.0, timestamp, amlData);
    }

    private Location getLocation(Instant timestamp, @Nullable AmlData amlData, CircleType circle) {
        List coordinates = circle.getPos().getValue();
        return new Location(Double.valueOf((String)coordinates.get(0)), Double.valueOf((String)coordinates.get(1)), circle.getRadius().getValue(), timestamp, amlData);
    }
}

