/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal.parser;

import at.gridgears.held.CivicAddress;
import at.gridgears.held.internal.parser.ParseUtils;
import at.gridgears.schemas.held.Geopriv;
import at.gridgears.schemas.held.LocInfoType;
import at.gridgears.schemas.held.LocationResponseType;
import at.gridgears.schemas.held.Presence;
import at.gridgears.schemas.held.Status;
import at.gridgears.schemas.held.Tuple;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

final class CivicAddressParser {
    CivicAddressParser() {
    }

    List<CivicAddress> parse(LocationResponseType locationResponseType) {
        LinkedList<CivicAddress> result = new LinkedList<CivicAddress>();
        ParseUtils.getValue(locationResponseType.getAny(), Presence.class).map(Presence::getTuple).map(ParseUtils::first).map(Tuple::getStatus).map(Status::getAny).map(ParseUtils::first).map(CivicAddressParser::getGeopriv).ifPresent(geopriv -> result.addAll(this.parseCivicAddresses((Geopriv)geopriv)));
        return result;
    }

    private List<CivicAddress> parseCivicAddresses(Geopriv geopriv) {
        LinkedList<CivicAddress> result = new LinkedList<CivicAddress>();
        LocInfoType locationInfo = geopriv.getLocationInfo();
        if (locationInfo != null) {
            result.addAll(this.parseCivicAddresses(locationInfo.getAny()));
        }
        return result;
    }

    private List<CivicAddress> parseCivicAddresses(List<Object> locations) {
        LinkedList<CivicAddress> result = new LinkedList<CivicAddress>();
        locations.forEach(location -> {
            Optional<at.gridgears.schemas.held.CivicAddress> civicAddressOptional = ParseUtils.getValue(location, at.gridgears.schemas.held.CivicAddress.class);
            if (civicAddressOptional.isPresent()) {
                civicAddressOptional.ifPresent(civic -> result.add(this.getCivicAddress((at.gridgears.schemas.held.CivicAddress)civic)));
            }
        });
        return result;
    }

    private CivicAddress getCivicAddress(at.gridgears.schemas.held.CivicAddress civic) {
        CivicAddress.CivicAddressBuilder builder = CivicAddress.CivicAddressBuilder.builder();
        builder.withCountry(civic.getCountry());
        ParseUtils.getStringValue(civic.getA1()).ifPresent(builder::withA1);
        ParseUtils.getStringValue(civic.getA2()).ifPresent(builder::withA2);
        ParseUtils.getStringValue(civic.getA3()).ifPresent(builder::withA3);
        ParseUtils.getStringValue(civic.getA4()).ifPresent(builder::withA4);
        ParseUtils.getStringValue(civic.getA5()).ifPresent(builder::withA5);
        ParseUtils.getStringValue(civic.getA6()).ifPresent(builder::withA6);
        ParseUtils.getStringValue(civic.getPRM()).ifPresent(builder::withPrm);
        ParseUtils.getStringValue(civic.getPRD()).ifPresent(builder::withPrd);
        ParseUtils.getStringValue(civic.getRD()).ifPresent(builder::withRd);
        ParseUtils.getStringValue(civic.getSTS()).ifPresent(builder::withSts);
        ParseUtils.getStringValue(civic.getPOD()).ifPresent(builder::withPod);
        ParseUtils.getStringValue(civic.getPOM()).ifPresent(builder::withPom);
        ParseUtils.getStringValue(civic.getRDSEC()).ifPresent(builder::withRdsec);
        ParseUtils.getStringValue(civic.getRDBR()).ifPresent(builder::withRdbr);
        ParseUtils.getStringValue(civic.getRDSUBBR()).ifPresent(builder::withRdsubbr);
        ParseUtils.getStringValue(civic.getHNO()).ifPresent(builder::withHno);
        ParseUtils.getStringValue(civic.getHNS()).ifPresent(builder::withHns);
        ParseUtils.getStringValue(civic.getLMK()).ifPresent(builder::withLmk);
        ParseUtils.getStringValue(civic.getLOC()).ifPresent(builder::withLoc);
        ParseUtils.getStringValue(civic.getFLR()).ifPresent(builder::withFlr);
        ParseUtils.getStringValue(civic.getNAM()).ifPresent(builder::withNam);
        ParseUtils.getStringValue(civic.getPC()).ifPresent(builder::withPc);
        ParseUtils.getStringValue(civic.getBLD()).ifPresent(builder::withBld);
        ParseUtils.getStringValue(civic.getUNIT()).ifPresent(builder::withUnit);
        ParseUtils.getStringValue(civic.getROOM()).ifPresent(builder::withRoom);
        ParseUtils.getStringValue(civic.getSEAT()).ifPresent(builder::withSeat);
        builder.withPlc(civic.getPLC());
        ParseUtils.getStringValue(civic.getPCN()).ifPresent(builder::withPcn);
        ParseUtils.getStringValue(civic.getPOBOX()).ifPresent(builder::withPobox);
        ParseUtils.getStringValue(civic.getADDCODE()).ifPresent(builder::withAddcode);
        return builder.build();
    }

    private static Geopriv getGeopriv(Object object) {
        return ParseUtils.getValue(object, Geopriv.class).get();
    }
}

