/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal;

import at.gridgears.held.FindLocationCallback;
import at.gridgears.held.FindLocationRequest;
import at.gridgears.held.FindLocationResult;
import at.gridgears.held.Held;
import at.gridgears.held.internal.FindLocationRequestFactory;
import at.gridgears.held.internal.HeldClientConfig;
import at.gridgears.held.internal.HeldException;
import at.gridgears.held.internal.parser.ResponseParser;
import at.gridgears.held.internal.parser.ResponseParsingException;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeldClient
implements Held {
    private static final Logger LOG = LogManager.getLogger();
    private final FindLocationRequestFactory findLocationRequestFactory;
    private final URI uri;
    private final CloseableHttpAsyncClient httpclient;
    private final ResponseParser responseParser;

    public HeldClient(HeldClientConfig config) {
        this(config, HttpAsyncClients.createDefault(), new ResponseParser(config.getLanguage()), new FindLocationRequestFactory(config.getRequestHeaders()));
    }

    HeldClient(HeldClientConfig config, CloseableHttpAsyncClient httpclient, ResponseParser responseParser, FindLocationRequestFactory findLocationRequestFactory) {
        Validate.notNull((Object)config, (String)"config must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)httpclient, (String)"httpclient must not  be null", (Object[])new Object[0]);
        Validate.notNull((Object)responseParser, (String)"responseParser must not  be null", (Object[])new Object[0]);
        Validate.notNull((Object)findLocationRequestFactory, (String)"findLocationRequestFactory must not  be null", (Object[])new Object[0]);
        this.uri = config.getUri();
        this.httpclient = httpclient;
        this.responseParser = responseParser;
        this.findLocationRequestFactory = findLocationRequestFactory;
    }

    @Override
    public void findLocation(final FindLocationRequest request, final FindLocationCallback callback) {
        Validate.notNull((Object)request, (String)"request must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)callback, (String)"callback must not be null", (Object[])new Object[0]);
        final HttpPost httpPost = this.findLocationRequestFactory.createRequest(this.uri, request);
        this.startHttpClientIfNecessary();
        this.httpclient.execute((HttpUriRequest)httpPost, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        String heldResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        LOG.debug("Received response for deviceIdentifier '{}': {}", (Object)request.getIdentifier(), (Object)heldResponse);
                        FindLocationResult findLocationResult = HeldClient.this.responseParser.parse(heldResponse);
                        findLocationResult.setRawRequest(EntityUtils.toString((HttpEntity)httpPost.getEntity()));
                        callback.completed(request, findLocationResult);
                    } else {
                        callback.failed(request, new HeldException("HTTP error", statusCode + ": " + response.getStatusLine().getReasonPhrase()));
                    }
                }
                catch (ResponseParsingException e) {
                    LOG.warn("Could not parse response content", (Throwable)e);
                    callback.failed(request, e);
                }
                catch (IOException e) {
                    LOG.warn("Could not extract response content", (Throwable)e);
                    callback.failed(request, e);
                }
            }

            public void failed(Exception e) {
                LOG.warn("Error during HELD request", (Throwable)e);
                callback.failed(request, e);
            }

            public void cancelled() {
                callback.failed(request, (Exception)new RequestAbortedException("Request cancelled"));
            }
        });
    }

    private void startHttpClientIfNecessary() {
        if (!this.httpclient.isRunning()) {
            this.httpclient.start();
        }
    }

    public void stop() {
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            LOG.error("Exception while closing HttpClient", (Throwable)e);
        }
    }
}

