/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held;

import at.gridgears.held.Held;
import at.gridgears.held.internal.HeldClient;
import at.gridgears.held.internal.HeldClientConfig;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class HeldBuilder {
    private URI uri;
    private String language = "en";
    private final List<Header> requestHeaders = new LinkedList<Header>();

    public HeldBuilder withURI(String uri) {
        Validate.notNull((Object)uri, (String)"uri must not be null", (Object[])new Object[0]);
        this.uri = URI.create(uri);
        return this;
    }

    public HeldBuilder withLanguage(String language) {
        Validate.notNull((Object)language, (String)"language must not be null", (Object[])new Object[0]);
        this.language = language;
        return this;
    }

    public HeldBuilder withHeader(String name, @Nullable String value) {
        Validate.notNull((Object)name, (String)"name must not be null", (Object[])new Object[0]);
        this.requestHeaders.add((Header)new BasicHeader(name, value));
        return this;
    }

    public Held build() {
        HeldClientConfig config = new HeldClientConfig(this.uri, this.language, this.requestHeaders);
        return new HeldClient(config);
    }
}

