/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal.parser;

import at.gridgears.schemas.held.CaType;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;

final class ParseUtils {
    private ParseUtils() {
    }

    static <T> Optional<T> getValue(Object element, Class<T> expectedClass) {
        Object value;
        Object result = null;
        if (element instanceof JAXBElement && expectedClass.isAssignableFrom((value = ((JAXBElement)element).getValue()).getClass())) {
            result = value;
        }
        return Optional.ofNullable(result);
    }

    static <T> Optional<T> getValue(List<Object> elements, Class<T> expectedClass) {
        Object result = null;
        for (Object element : elements) {
            Optional<T> optional = ParseUtils.getValue(element, expectedClass);
            if (!optional.isPresent()) continue;
            result = optional.get();
            break;
        }
        return Optional.ofNullable(result);
    }

    static <T> T first(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(0);
    }

    static Optional<String> getStringValue(CaType element) {
        return Optional.ofNullable(element != null ? element.getValue() : null);
    }

    static Instant toInstant(XMLGregorianCalendar xmlGregorianCalendar) {
        return xmlGregorianCalendar.toGregorianCalendar().getTime().toInstant();
    }
}

