/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FindLocationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String responseTime;
    private final List<LocationType> locationTypes;
    private final boolean exact;

    public FindLocationRequest(String identifier) {
        this(identifier, Collections.emptyList(), false, null);
    }

    public FindLocationRequest(String identifier, List<LocationType> locationTypes, boolean exact) {
        this(identifier, locationTypes, exact, null);
    }

    public FindLocationRequest(String identifier, List<LocationType> locationTypes, boolean exact, @Nullable ResponseTime responseTime) {
        Validate.notEmpty((CharSequence)identifier, (String)"identifier must not be null or empty", (Object[])new Object[0]);
        Validate.notNull(locationTypes, (String)"locationTypes must not be null", (Object[])new Object[0]);
        Validate.noNullElements(locationTypes, (String)"locationTypes must not contain null values", (Object[])new Object[0]);
        this.identifier = identifier;
        this.responseTime = responseTime != null ? responseTime.getResponseTime() : null;
        this.locationTypes = locationTypes;
        this.exact = exact;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<String> getResponseTime() {
        return Optional.ofNullable(this.responseTime);
    }

    public List<LocationType> getLocationTypes() {
        return this.locationTypes;
    }

    public boolean isExact() {
        return this.exact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindLocationRequest request = (FindLocationRequest)o;
        return this.exact == request.exact && Objects.equals(this.identifier, request.identifier) && Objects.equals(this.responseTime, request.responseTime) && Objects.equals(this.locationTypes, request.locationTypes);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.responseTime, this.locationTypes, this.exact);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("identifier", (Object)this.identifier).append("responseTime", (Object)this.responseTime).append("locationTypes", this.locationTypes).append("exact", this.exact).toString();
    }

    public static class ResponseTime {
        private final String responseTime;

        private ResponseTime(String responseTime) {
            this.responseTime = responseTime;
        }

        public static ResponseTime createForDuration(Duration responseTime) {
            Validate.notNull((Object)responseTime, (String)"responseTime must not be null", (Object[])new Object[0]);
            if (responseTime.toMillis() < 0L) {
                throw new IllegalArgumentException("responseTime must not be negative");
            }
            return new ResponseTime(String.valueOf(responseTime.toMillis()));
        }

        public static ResponseTime createForEmergencyRouting() {
            return new ResponseTime("emergencyRouting");
        }

        public static ResponseTime createForEmergencyDispatch() {
            return new ResponseTime("emergencyDispatch");
        }

        String getResponseTime() {
            return this.responseTime;
        }
    }

    public static enum LocationType {
        ANY,
        GEODETIC,
        CIVIC,
        LOCATION_URI;

    }
}

