/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class LocationReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final Instant expiration;

    public LocationReference(URI uri, Instant expiration) {
        this.uri = uri;
        this.expiration = expiration;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isExpired() {
        return this.expiration.isBefore(Instant.now());
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationReference that = (LocationReference)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.expiration, that.expiration);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.expiration);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uri", (Object)this.uri).append("expiration", (Object)this.expiration).toString();
    }
}

