/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held;

import at.gridgears.held.AmlData;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double latitude;
    private final double longitude;
    private final double radius;
    private final Instant timestamp;
    private final AmlData amlData;

    public Location(double latitude, double longitude, double radius, Instant timestamp) {
        this(latitude, longitude, radius, timestamp, null);
    }

    public Location(double latitude, double longitude, double radius, Instant timestamp, AmlData amlData) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
        this.timestamp = timestamp;
        this.amlData = amlData;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadius() {
        return this.radius;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<AmlData> getAmlData() {
        return Optional.ofNullable(this.amlData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return Double.compare(location.latitude, this.latitude) == 0 && Double.compare(location.longitude, this.longitude) == 0 && Double.compare(location.radius, this.radius) == 0 && Objects.equals(this.timestamp, location.timestamp) && Objects.equals(this.amlData, location.amlData);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude, this.radius, this.timestamp, this.amlData);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("latitude", this.latitude).append("longitude", this.longitude).append("radius", this.radius).append("timestamp", (Object)this.timestamp).append("amlData", (Object)this.amlData).toString();
    }
}

