/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held.internal.parser;

import at.gridgears.held.Location;
import at.gridgears.held.LocationReference;
import at.gridgears.held.internal.parser.JaxbElementUtil;
import at.gridgears.held.internal.parser.ResponseParsingException;
import at.gridgears.schemas.held.CircleType;
import at.gridgears.schemas.held.Geopriv;
import at.gridgears.schemas.held.LocationResponseType;
import at.gridgears.schemas.held.PointType;
import at.gridgears.schemas.held.Presence;
import at.gridgears.schemas.held.ReturnLocationType;
import at.gridgears.schemas.held.Status;
import at.gridgears.schemas.held.Tuple;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

class SuccessResultParser {
    SuccessResultParser() {
    }

    Pair<List<Location>, List<LocationReference>> parse(LocationResponseType locationResponseType) throws ResponseParsingException {
        try {
            List<Location> resultLocations = this.extractLocations(locationResponseType);
            List<LocationReference> resultReferences = this.extractReferences(locationResponseType);
            return Pair.of(resultLocations, resultReferences);
        }
        catch (Exception e) {
            throw new ResponseParsingException("Error parsing LocationResponseType", e);
        }
    }

    private List<LocationReference> extractReferences(LocationResponseType locationResponseType) {
        MutableObject expires = new MutableObject();
        LinkedList<LocationReference> result = new LinkedList<LocationReference>();
        Optional.ofNullable(locationResponseType.getLocationUriSet()).map(this.storeExpires((MutableObject<Instant>)expires)).map(ReturnLocationType::getLocationURI).map(Collection::stream).ifPresent(stream -> stream.forEach(uri -> result.add(new LocationReference(URI.create(uri.trim()), (Instant)expires.getValue()))));
        return result;
    }

    private List<Location> extractLocations(LocationResponseType locationResponseType) {
        MutableObject timestamp = new MutableObject();
        LinkedList<Location> result = new LinkedList<Location>();
        JaxbElementUtil.getValue(locationResponseType.getAny(), Presence.class).map(Presence::getTuple).map(SuccessResultParser::first).map(this.storeTimestamp((MutableObject<Instant>)timestamp)).map(Tuple::getStatus).map(Status::getAny).map(SuccessResultParser::first).map(SuccessResultParser::getGeopriv).map(Geopriv::getLocationInfo).ifPresent(locInfoType -> result.addAll(this.parseLocations(locInfoType.getAny(), (Instant)timestamp.getValue())));
        return result;
    }

    private Function<ReturnLocationType, ReturnLocationType> storeExpires(MutableObject<Instant> expires) {
        return returnLocationType -> {
            expires.setValue((Object)this.toInstant(returnLocationType.getExpires()));
            return returnLocationType;
        };
    }

    private Function<Tuple, Tuple> storeTimestamp(MutableObject<Instant> timestamp) {
        return tuple -> {
            timestamp.setValue((Object)this.getTimestamp((Tuple)tuple));
            return tuple;
        };
    }

    private static <T> T first(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(0);
    }

    private static Geopriv getGeopriv(Object object) {
        return JaxbElementUtil.getValue(object, Geopriv.class).get();
    }

    private Instant getTimestamp(Tuple tuple) {
        XMLGregorianCalendar tupleTimestamp = tuple.getTimestamp();
        return this.toInstant(tupleTimestamp);
    }

    private Instant toInstant(XMLGregorianCalendar tupleTimestamp) {
        return tupleTimestamp.toGregorianCalendar().getTime().toInstant();
    }

    private List<Location> parseLocations(List<Object> locations, Instant timestamp) {
        LinkedList<Location> result = new LinkedList<Location>();
        locations.forEach(location -> {
            Optional<PointType> pointTypeOptional = JaxbElementUtil.getValue(location, PointType.class);
            if (pointTypeOptional.isPresent()) {
                pointTypeOptional.ifPresent(point -> result.add(this.getLocation(timestamp, (PointType)point)));
            } else {
                Optional<CircleType> circleTypeOptional = JaxbElementUtil.getValue(location, CircleType.class);
                circleTypeOptional.ifPresent(circle -> result.add(this.getLocation(timestamp, (CircleType)circle)));
            }
        });
        return result;
    }

    private Location getLocation(Instant timestamp, PointType point) {
        List coordinates = point.getPos().getValue();
        return new Location(Double.valueOf((String)coordinates.get(0)), Double.valueOf((String)coordinates.get(1)), 0.0, timestamp);
    }

    private Location getLocation(Instant timestamp, CircleType circle) {
        List coordinates = circle.getPos().getValue();
        return new Location(Double.valueOf((String)coordinates.get(0)), Double.valueOf((String)coordinates.get(1)), circle.getRadius().getValue(), timestamp);
    }
}

