/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.held;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double latitude;
    private final double longitude;
    private final double radius;
    private final Instant timestamp;

    public Location(double latitude, double longitude, double radius, Instant timestamp) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
        this.timestamp = timestamp;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadius() {
        return this.radius;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return Double.compare(location.latitude, this.latitude) == 0 && Double.compare(location.longitude, this.longitude) == 0 && Double.compare(location.radius, this.radius) == 0 && Objects.equals(this.timestamp, location.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude, this.radius, this.timestamp);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("latitude", this.latitude).append("longitude", this.longitude).append("radius", this.radius).append("timestamp", (Object)this.timestamp).toString();
    }
}

