/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.aml.builder;

import at.gridgears.aml.AmlMessage;
import at.gridgears.aml.PositioningMethod;
import at.gridgears.aml.builder.AmlMessageBuilder;
import java.time.Instant;

public final class DefaultAmlMessageBuilder
implements AmlMessageBuilder<AmlMessage> {
    private Integer version;
    private Double latitude;
    private Double longitude;
    private Double radiusMeters;
    private String imsi;
    private String imei;
    private Instant timeOfPositioning;
    private Integer levelOfConfidence;
    private PositioningMethod positionMethod;
    private String mcc;
    private String mnc;
    private Integer length;

    private DefaultAmlMessageBuilder() {
    }

    public static DefaultAmlMessageBuilder newAdvancedMobileLocation() {
        return new DefaultAmlMessageBuilder();
    }

    public DefaultAmlMessageBuilder version(Integer version) {
        this.version = version;
        return this;
    }

    public DefaultAmlMessageBuilder latitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    public DefaultAmlMessageBuilder longitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    public DefaultAmlMessageBuilder radiusMeters(Double radiusMeters) {
        this.radiusMeters = radiusMeters;
        return this;
    }

    public DefaultAmlMessageBuilder imsi(String imsi) {
        this.imsi = imsi;
        return this;
    }

    public DefaultAmlMessageBuilder imei(String imei) {
        this.imei = imei;
        return this;
    }

    public DefaultAmlMessageBuilder timeOfPositioning(Instant timeOfPositioning) {
        this.timeOfPositioning = timeOfPositioning;
        return this;
    }

    public DefaultAmlMessageBuilder levelOfConfidence(Integer levelOfConfidence) {
        this.levelOfConfidence = levelOfConfidence;
        return this;
    }

    public DefaultAmlMessageBuilder positionMethod(PositioningMethod positionMethod) {
        this.positionMethod = positionMethod;
        return this;
    }

    public DefaultAmlMessageBuilder mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public DefaultAmlMessageBuilder mnc(String mnc) {
        this.mnc = mnc;
        return this;
    }

    public DefaultAmlMessageBuilder length(Integer length) {
        this.length = length;
        return this;
    }

    @Override
    public AmlMessage build() {
        return new AmlMessage(this.version, this.latitude, this.longitude, this.radiusMeters, this.imsi, this.imei, this.timeOfPositioning, this.levelOfConfidence, this.positionMethod, this.mcc, this.mnc, this.length);
    }
}

