/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.aml;

import at.gridgears.aml.AmlMessage;
import java.time.Instant;

public final class AmlMessageBuilder {
    private Integer version;
    private Double latitude;
    private Double longitude;
    private Double radiusMeters;
    private String imsi;
    private String imei;
    private Instant timeOfPositioning;
    private Integer levelOfConfidence;
    private AmlMessage.PositioningMethod positionMethod;
    private String mcc;
    private String mnc;
    private Integer length;

    private AmlMessageBuilder() {
    }

    public static AmlMessageBuilder newAdvancedMobileLocation() {
        return new AmlMessageBuilder();
    }

    public AmlMessageBuilder version(Integer version) {
        this.version = version;
        return this;
    }

    public AmlMessageBuilder latitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    public AmlMessageBuilder longitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    public AmlMessageBuilder radiusMeters(Double radiusMeters) {
        this.radiusMeters = radiusMeters;
        return this;
    }

    public AmlMessageBuilder imsi(String imsi) {
        this.imsi = imsi;
        return this;
    }

    public AmlMessageBuilder imei(String imei) {
        this.imei = imei;
        return this;
    }

    public AmlMessageBuilder timeOfPositioning(Instant timeOfPositioning) {
        this.timeOfPositioning = timeOfPositioning;
        return this;
    }

    public AmlMessageBuilder levelOfConfidence(Integer levelOfConfidence) {
        this.levelOfConfidence = levelOfConfidence;
        return this;
    }

    public AmlMessageBuilder positionMethod(AmlMessage.PositioningMethod positionMethod) {
        this.positionMethod = positionMethod;
        return this;
    }

    public AmlMessageBuilder mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public AmlMessageBuilder mnc(String mnc) {
        this.mnc = mnc;
        return this;
    }

    public AmlMessageBuilder length(Integer length) {
        this.length = length;
        return this;
    }

    public AmlMessage build() {
        return new AmlMessage(this.version, this.latitude, this.longitude, this.radiusMeters, this.imsi, this.imei, this.timeOfPositioning, this.levelOfConfidence, this.positionMethod, this.mcc, this.mnc, this.length);
    }
}

