/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.aml;

import at.gridgears.aml.AmlMessage;
import at.gridgears.aml.PositioningMethodMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.TimeZone;

class Attribute {
    private static final String SEPARATOR = "=";
    private static final String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final PositioningMethodMapper POSITIONING_METHOD_MAPPER = new PositioningMethodMapper();
    private final String name;
    private final String value;

    private Attribute(String name, String value) {
        this.name = name;
        this.value = value;
    }

    static Attribute create(String input) {
        String[] attribute = input.split(SEPARATOR);
        String name = attribute[0];
        String value = attribute.length > 1 ? attribute[1] : null;
        return new Attribute(name, value);
    }

    String getName() {
        return this.name;
    }

    String getStringValue() {
        return this.value;
    }

    Integer getIntegerValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    Double getDoubleValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    Instant getInstantValue() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return format.parse(this.value).toInstant();
        }
        catch (ParseException e) {
            return null;
        }
    }

    AmlMessage.PositioningMethod getPositioningMethod() {
        try {
            return POSITIONING_METHOD_MAPPER.get(this.value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

