/*
 * Decompiled with CFR 0.152.
 */
package at.gridgears.aml;

import at.gridgears.aml.AmlMessage;
import java.time.Instant;

final class AmlMessageBuilder {
    private Integer version;
    private Double latitude;
    private Double longitude;
    private Double radiusMeters;
    private String imsi;
    private String imei;
    private Instant timeOfPositioning;
    private Integer levelOfConfidence;
    private AmlMessage.PositioningMethod positionMethod;
    private String mcc;
    private String mnc;
    private Integer length;

    private AmlMessageBuilder() {
    }

    static AmlMessageBuilder newAdvancedMobileLocation() {
        return new AmlMessageBuilder();
    }

    AmlMessageBuilder version(Integer version) {
        this.version = version;
        return this;
    }

    AmlMessageBuilder latitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    AmlMessageBuilder longitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    AmlMessageBuilder radiusMeters(Double radiusMeters) {
        this.radiusMeters = radiusMeters;
        return this;
    }

    AmlMessageBuilder imsi(String imsi) {
        this.imsi = imsi;
        return this;
    }

    AmlMessageBuilder imei(String imei) {
        this.imei = imei;
        return this;
    }

    AmlMessageBuilder timeOfPositioning(Instant timeOfPositioning) {
        this.timeOfPositioning = timeOfPositioning;
        return this;
    }

    AmlMessageBuilder levelOfConfidence(Integer levelOfConfidence) {
        this.levelOfConfidence = levelOfConfidence;
        return this;
    }

    AmlMessageBuilder positionMethod(AmlMessage.PositioningMethod positionMethod) {
        this.positionMethod = positionMethod;
        return this;
    }

    AmlMessageBuilder mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    AmlMessageBuilder mnc(String mnc) {
        this.mnc = mnc;
        return this;
    }

    AmlMessageBuilder length(Integer length) {
        this.length = length;
        return this;
    }

    AmlMessage build() {
        return new AmlMessage(this.version, this.latitude, this.longitude, this.radiusMeters, this.imsi, this.imei, this.timeOfPositioning, this.levelOfConfidence, this.positionMethod, this.mcc, this.mnc, this.length);
    }
}

