/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor.field.renaming;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.processor.field.renaming.Renamer;
import java.util.Map;

public class RenameByRegExp
extends Renamer {
    private Map<String, PatternReplace> fieldRegExps;

    public RenameByRegExp(MongoDbSinkConnectorConfig config, String collection) {
        super(config, collection);
        this.fieldRegExps = config.parseRenameRegExpSettings(collection);
    }

    public RenameByRegExp(MongoDbSinkConnectorConfig config, Map<String, PatternReplace> fieldRegExps, String collection) {
        super(config, collection);
        this.fieldRegExps = fieldRegExps;
    }

    @Override
    protected boolean isActive() {
        return !this.fieldRegExps.isEmpty();
    }

    @Override
    protected String renamed(String path, String name) {
        String newName = name;
        for (Map.Entry<String, PatternReplace> e : this.fieldRegExps.entrySet()) {
            if (!(path + "." + name).matches(e.getKey())) continue;
            newName = newName.replaceAll(e.getValue().pattern, e.getValue().replace);
        }
        return newName;
    }

    public static class PatternReplace {
        public final String pattern;
        public final String replace;

        public PatternReplace(String pattern, String replace) {
            this.pattern = pattern;
            this.replace = replace;
        }

        public String toString() {
            return "PatternReplace{pattern='" + this.pattern + '\'' + ", replace='" + this.replace + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternReplace that = (PatternReplace)o;
            if (this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null) {
                return false;
            }
            return this.replace != null ? this.replace.equals(that.replace) : that.replace == null;
        }

        public int hashCode() {
            int result = this.pattern != null ? this.pattern.hashCode() : 0;
            result = 31 * result + (this.replace != null ? this.replace.hashCode() : 0);
            return result;
        }
    }
}

