/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor.field.renaming;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.processor.field.renaming.Renamer;
import java.util.Map;

public class RenameByMapping
extends Renamer {
    private Map<String, String> fieldMappings;

    public RenameByMapping(MongoDbSinkConnectorConfig config, String collection) {
        super(config, collection);
        this.fieldMappings = config.parseRenameFieldnameMappings(collection);
    }

    public RenameByMapping(MongoDbSinkConnectorConfig config, Map<String, String> fieldMappings, String collection) {
        super(config, collection);
        this.fieldMappings = fieldMappings;
    }

    @Override
    protected boolean isActive() {
        return !this.fieldMappings.isEmpty();
    }

    @Override
    protected String renamed(String path, String name) {
        String newName = this.fieldMappings.get(path + "." + name);
        return newName != null ? newName : name;
    }
}

