/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.processor.field.projection.WhitelistProjector;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;

public class WhitelistKeyProjector
extends WhitelistProjector {
    private Predicate<MongoDbSinkConnectorConfig> predicate;

    public WhitelistKeyProjector(MongoDbSinkConnectorConfig config, String collection) {
        this(config, config.getKeyProjectionList(collection), cfg -> cfg.isUsingWhitelistKeyProjection(collection), collection);
    }

    public WhitelistKeyProjector(MongoDbSinkConnectorConfig config, Set<String> fields, Predicate<MongoDbSinkConnectorConfig> predicate, String collection) {
        super(config, collection);
        this.fields = fields;
        this.predicate = predicate;
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        if (this.predicate.test(this.getConfig())) {
            doc.getKeyDoc().ifPresent(kd -> this.doProjection("", (BsonDocument)kd));
        }
        this.getNext().ifPresent(pp -> pp.process(doc, orig));
    }
}

