/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.processor.PostProcessor;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.IdStrategy;
import org.apache.kafka.connect.sink.SinkRecord;

public class DocumentIdAdder
extends PostProcessor {
    protected final IdStrategy idStrategy;

    public DocumentIdAdder(MongoDbSinkConnectorConfig config, String collection) {
        this(config, config.getIdStrategy(collection), collection);
    }

    public DocumentIdAdder(MongoDbSinkConnectorConfig config, IdStrategy idStrategy, String collection) {
        super(config, collection);
        this.idStrategy = idStrategy;
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        doc.getValueDoc().ifPresent(vd -> vd.append("_id", this.idStrategy.generateId(doc, orig)));
        this.getNext().ifPresent(pp -> pp.process(doc, orig));
    }
}

