/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.processor.field.projection.BlacklistProjector;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;

public class BlacklistValueProjector
extends BlacklistProjector {
    private Predicate<MongoDbSinkConnectorConfig> predicate;

    public BlacklistValueProjector(MongoDbSinkConnectorConfig config, String collection) {
        this(config, config.getValueProjectionList(collection), cfg -> cfg.isUsingBlacklistValueProjection(collection), collection);
    }

    public BlacklistValueProjector(MongoDbSinkConnectorConfig config, Set<String> fields, Predicate<MongoDbSinkConnectorConfig> predicate, String collection) {
        super(config, collection);
        this.fields = fields;
        this.predicate = predicate;
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        if (this.predicate.test(this.getConfig())) {
            doc.getValueDoc().ifPresent(vd -> this.fields.forEach(f -> this.doProjection((String)f, (BsonDocument)vd)));
        }
        this.getNext().ifPresent(pp -> pp.process(doc, orig));
    }
}

