/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.converter;

import at.grahsl.kafka.connect.mongodb.converter.RecordConverter;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class JsonSchemalessRecordConverter
implements RecordConverter {
    private CodecRegistry codecRegistry = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new DocumentCodecProvider(), new BsonValueCodecProvider(), new ValueCodecProvider()});

    @Override
    public BsonDocument convert(Schema schema, Object value) {
        if (value == null) {
            throw new DataException("error: value was null for JSON conversion");
        }
        return new Document((Map)value).toBsonDocument(null, this.codecRegistry);
    }
}

