/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.outbox;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.DebeziumCdcHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsDelete;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsInsert;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsUpdate;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.outbox.OutboxInsert;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.WriteModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboxHandler
extends DebeziumCdcHandler {
    public static final String JSON_DOC_BEFORE_FIELD = "before";
    public static final String JSON_DOC_AFTER_FIELD = "after";
    public static final String JSON_DOC_PAYLOAD_FIELD = "payload";
    public static final String PAYLOAD_DEFAULT_ID_FIELD = "id";
    private static Logger logger = LoggerFactory.getLogger(OutboxHandler.class);

    public OutboxHandler(MongoDbSinkConnectorConfig config) {
        super(config);
        HashMap<OperationType, CdcOperation> operations = new HashMap<OperationType, CdcOperation>();
        operations.put(OperationType.CREATE, new RdbmsInsert());
        operations.put(OperationType.READ, new RdbmsInsert());
        operations.put(OperationType.UPDATE, new RdbmsUpdate());
        operations.put(OperationType.DELETE, new RdbmsDelete());
        this.registerOperations(operations);
    }

    public OutboxHandler(MongoDbSinkConnectorConfig config, Map<OperationType, CdcOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument payload;
        BsonDocument keyDoc = doc.getKeyDoc().orElseGet(BsonDocument::new);
        BsonDocument valueDoc = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (valueDoc.isEmpty()) {
            logger.debug("skipping debezium tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        CdcOperation op = this.getCdcOperation(valueDoc);
        if (op instanceof OutboxInsert && !(payload = OutboxHandler.extractAndParseBsonDocumentFromPayloadField(valueDoc)).containsKey((Object)PAYLOAD_DEFAULT_ID_FIELD)) {
            logger.debug("skipping debezium cdc outbox event which is missing the default 'id' field and is thus most likely not an aggregate root");
            return Optional.empty();
        }
        return Optional.ofNullable(this.getCdcOperation(valueDoc).perform(new SinkDocument(keyDoc, valueDoc)));
    }

    protected static BsonDocument extractAndParseBsonDocumentFromPayloadField(BsonDocument valueDoc) {
        try {
            BsonDocument payload = BsonDocument.parse((String)valueDoc.getDocument((Object)JSON_DOC_AFTER_FIELD).getString((Object)JSON_DOC_PAYLOAD_FIELD).getValue());
            if (payload.isEmpty()) {
                throw new BsonInvalidOperationException("after contains an empty payload field");
            }
            return payload;
        }
        catch (BsonInvalidOperationException exc) {
            throw new DataException("error: value doc 'payload' field is empty or has invalid type for insert/read operation which seems severely wrong -> defensive actions taken!", (Throwable)exc);
        }
    }

    protected static BsonDocument generateFilterDoc(BsonDocument keyDoc, BsonDocument valueDoc, OperationType opType) {
        if (opType.equals((Object)OperationType.CREATE) || opType.equals((Object)OperationType.READ)) {
            BsonDocument payload = OutboxHandler.extractAndParseBsonDocumentFromPayloadField(valueDoc);
            return new BsonDocument("_id", (BsonValue)new BsonDocument(PAYLOAD_DEFAULT_ID_FIELD, payload.get((Object)PAYLOAD_DEFAULT_ID_FIELD)));
        }
        if (opType.equals((Object)OperationType.UPDATE)) {
            throw new DataException("error: operation type " + (Object)((Object)OperationType.UPDATE) + " unexpected and not allowed for outbox events");
        }
        if (opType.equals((Object)OperationType.DELETE)) {
            throw new DataException("error: operation type " + (Object)((Object)OperationType.DELETE) + " must not be handled for outbox events - a no op should be configured for this");
        }
        throw new DataException("error: unknown or invalid operation type " + (Object)((Object)opType));
    }

    protected static BsonDocument generateUpsertOrReplaceDoc(BsonDocument keyDoc, BsonDocument valueDoc, BsonDocument filterDoc) {
        BsonDocument payloadDoc = OutboxHandler.extractAndParseBsonDocumentFromPayloadField(valueDoc);
        BsonDocument upsertDoc = new BsonDocument();
        if (filterDoc.containsKey((Object)"_id")) {
            upsertDoc.put("_id", filterDoc.get((Object)"_id"));
        }
        payloadDoc.keySet().forEach(f -> upsertDoc.put(f, payloadDoc.get(f)));
        return upsertDoc;
    }
}

