/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb;

import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoDbInsert
implements CdcOperation {
    public static final String JSON_DOC_FIELD_PATH = "after";
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("error: value doc must not be missing for insert operation"));
        try {
            BsonDocument insertDoc = BsonDocument.parse((String)valueDoc.get((Object)JSON_DOC_FIELD_PATH).asString().getValue());
            return new ReplaceOneModel((Bson)new BsonDocument("_id", insertDoc.get((Object)"_id")), (Object)insertDoc, UPDATE_OPTIONS);
        }
        catch (Exception exc) {
            throw new DataException((Throwable)exc);
        }
    }
}

