/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.cdc.CdcHandler;
import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public abstract class DebeziumCdcHandler
extends CdcHandler {
    public static final String OPERATION_TYPE_FIELD_PATH = "op";
    private final Map<OperationType, CdcOperation> operations = new HashMap<OperationType, CdcOperation>();

    public DebeziumCdcHandler(MongoDbSinkConnectorConfig config) {
        super(config);
    }

    protected void registerOperations(Map<OperationType, CdcOperation> operations) {
        this.operations.putAll(operations);
    }

    public CdcOperation getCdcOperation(BsonDocument doc) {
        try {
            if (!doc.containsKey((Object)OPERATION_TYPE_FIELD_PATH) || !doc.get((Object)OPERATION_TYPE_FIELD_PATH).isString()) {
                throw new DataException("error: value doc is missing CDC operation type of type string");
            }
            CdcOperation op = this.operations.get((Object)OperationType.fromText(doc.get((Object)OPERATION_TYPE_FIELD_PATH).asString().getValue()));
            if (op == null) {
                throw new DataException("error: no CDC operation found in mapping for op=" + doc.get((Object)OPERATION_TYPE_FIELD_PATH).asString().getValue());
            }
            return op;
        }
        catch (IllegalArgumentException exc) {
            throw new DataException("error: parsing CDC operation failed", (Throwable)exc);
        }
    }
}

