/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor.id.strategy;

import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.IdStrategy;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonNull;
import org.bson.BsonValue;

public class ProvidedStrategy
implements IdStrategy {
    protected ProvidedIn where;

    public ProvidedStrategy(ProvidedIn where) {
        this.where = where;
    }

    @Override
    public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
        BsonValue _id;
        Optional<Object> bd = Optional.empty();
        if (this.where.equals((Object)ProvidedIn.KEY)) {
            bd = doc.getKeyDoc();
        }
        if (this.where.equals((Object)ProvidedIn.VALUE)) {
            bd = doc.getValueDoc();
        }
        if ((_id = bd.map(d -> d.get((Object)"_id")).orElseThrow(() -> new DataException("error: provided id strategy is used but the document structure either contained no _id field or it was null"))) instanceof BsonNull) {
            throw new DataException("error: provided id strategy used but the document structure contained an _id of type BsonNull");
        }
        return _id;
    }

    protected static enum ProvidedIn {
        KEY,
        VALUE;

    }
}

