/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor.field.renaming;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.processor.PostProcessor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class Renamer
extends PostProcessor {
    public static final String PATH_PREFIX_KEY = "key";
    public static final String PATH_PREFIX_VALUE = "value";
    public static final String SUB_FIELD_DOT_SEPARATOR = ".";

    public Renamer(MongoDbSinkConnectorConfig config, String collection) {
        super(config, collection);
    }

    protected abstract String renamed(String var1, String var2);

    protected abstract boolean isActive();

    protected void doRenaming(String field, BsonDocument doc) {
        LinkedHashMap temp = new LinkedHashMap();
        Iterator iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String oldKey = (String)entry.getKey();
            BsonValue value = (BsonValue)entry.getValue();
            String newKey = this.renamed(field, oldKey);
            if (!oldKey.equals(newKey)) {
                doc.computeIfAbsent((Object)newKey, k -> temp.putIfAbsent(k, value));
                iter.remove();
            }
            if (!(value instanceof BsonDocument)) continue;
            String pathToField = field + SUB_FIELD_DOT_SEPARATOR + newKey;
            this.doRenaming(pathToField, (BsonDocument)value);
        }
        doc.putAll(temp);
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        if (this.isActive()) {
            doc.getKeyDoc().ifPresent(kd -> this.doRenaming(PATH_PREFIX_KEY, (BsonDocument)kd));
            doc.getValueDoc().ifPresent(vd -> this.doRenaming(PATH_PREFIX_VALUE, (BsonDocument)vd));
        }
    }
}

