/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.processor.PostProcessor;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;

public class KafkaMetaAdder
extends PostProcessor {
    public static final String KAFKA_META_DATA = "topic-partition-offset";

    public KafkaMetaAdder(MongoDbSinkConnectorConfig config, String collection) {
        super(config, collection);
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        doc.getValueDoc().ifPresent(vd -> {
            vd.put(KAFKA_META_DATA, (BsonValue)new BsonString(orig.topic() + "-" + orig.kafkaPartition() + "-" + orig.kafkaOffset()));
            vd.put(orig.timestampType().name(), (BsonValue)new BsonInt64(orig.timestamp().longValue()));
        });
        this.getNext().ifPresent(pp -> pp.process(doc, orig));
    }
}

