/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb;

import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoDbUpdate
implements CdcOperation {
    public static final String JSON_DOC_FIELD_PATH = "patch";
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("error: value doc must not be missing for update operation"));
        try {
            BsonDocument updateDoc = BsonDocument.parse((String)valueDoc.getString((Object)JSON_DOC_FIELD_PATH).getValue());
            if (updateDoc.containsKey((Object)"_id")) {
                BsonDocument filterDoc = new BsonDocument("_id", updateDoc.get((Object)"_id"));
                return new ReplaceOneModel((Bson)filterDoc, (Object)updateDoc, UPDATE_OPTIONS);
            }
            BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("error: key doc must not be missing for update operation"));
            BsonDocument filterDoc = BsonDocument.parse((String)("{_id:" + keyDoc.getString((Object)"id").getValue() + "}"));
            return new UpdateOneModel((Bson)filterDoc, (Bson)updateDoc);
        }
        catch (DataException exc) {
            exc.printStackTrace();
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new DataException(exc.getMessage(), (Throwable)exc);
        }
    }
}

