/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.DebeziumCdcHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb.MongoDbDelete;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb.MongoDbInsert;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb.MongoDbUpdate;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.WriteModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbHandler
extends DebeziumCdcHandler {
    public static final String JSON_ID_FIELD_PATH = "id";
    private static Logger logger = LoggerFactory.getLogger(MongoDbHandler.class);

    public MongoDbHandler(MongoDbSinkConnectorConfig config) {
        super(config);
        HashMap<OperationType, CdcOperation> operations = new HashMap<OperationType, CdcOperation>();
        operations.put(OperationType.CREATE, new MongoDbInsert());
        operations.put(OperationType.READ, new MongoDbInsert());
        operations.put(OperationType.UPDATE, new MongoDbUpdate());
        operations.put(OperationType.DELETE, new MongoDbDelete());
        this.registerOperations(operations);
    }

    public MongoDbHandler(MongoDbSinkConnectorConfig config, Map<OperationType, CdcOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("error: key document must not be missing for CDC mode"));
        BsonDocument valueDoc = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (keyDoc.containsKey((Object)JSON_ID_FIELD_PATH) && valueDoc.isEmpty()) {
            logger.debug("skipping debezium tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        logger.debug("key: " + keyDoc.toString());
        logger.debug("value: " + valueDoc.toString());
        return Optional.of(this.getCdcOperation(valueDoc).perform(doc));
    }
}

