/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class CollectionAwareConfig
extends AbstractConfig {
    private final Map<String, Object> collectionAwareSettings = new HashMap<String, Object>(256);

    public CollectionAwareConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(definition, originals, doLog);
        this.collectionAwareSettings.putAll(this.values());
        this.collectionAwareSettings.putAll(this.originals());
    }

    public CollectionAwareConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals);
        this.collectionAwareSettings.putAll(this.values());
        this.collectionAwareSettings.putAll(this.originals());
    }

    protected Object get(String property, String collection) {
        String fullProperty = property + "." + collection;
        if (this.collectionAwareSettings.containsKey(fullProperty)) {
            return this.collectionAwareSettings.get(fullProperty);
        }
        return this.collectionAwareSettings.get(property);
    }

    public String getString(String property, String collection) {
        if (collection == null || collection.isEmpty()) {
            return (String)this.get(property);
        }
        return (String)this.get(property, collection);
    }

    public Boolean getBoolean(String property, String collection) {
        Object obj = collection == null || collection.isEmpty() ? this.get(property) : this.get(property, collection);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        throw new ConfigException("error: unsupported property type for '" + obj + "' where Boolean expected");
    }

    public Integer getInt(String property, String collection) {
        Object obj = collection == null || collection.isEmpty() ? this.get(property) : this.get(property, collection);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        throw new ConfigException("error: unsupported property type for '" + obj + "' where Integer expected");
    }
}

