package at.florianschuster.androidreactor


/**
 * Object to handle Library initializations.
 */
object AndroidReactor {
    private var errorHandler: ((Throwable) -> Unit)? = null

    /**
     * Handles error messages, which are swallowed by the state stream by default.
     *
     * @param handler (Throwable) -> Unit
     */
    fun handleErrorsWith(handler: (Throwable) -> Unit) {
        this.errorHandler = handler
    }

    internal fun log(throwable: Throwable) {
        errorHandler?.invoke(throwable)
    }
}