/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto;

import at.favre.lib.crypto.HFunction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;

public interface HFunctionFactory {
    public HFunction createInstance();

    public String getDescription();

    public static final class Default {
        private Default() {
        }

        public static HFunctionFactory sha256() {
            return new DigestFactory("SHA-256", null);
        }

        public static HFunctionFactory sha512() {
            return new DigestFactory("SHA-512", null);
        }

        public static HFunctionFactory hmacSha256() {
            return new MacFactory("HmacSHA256", null);
        }

        public static HFunctionFactory hmacSha512() {
            return new MacFactory("HmacSHA512", null);
        }

        public static final class MacFactory
        implements HFunctionFactory {
            private final String algorithmName;
            private final Provider provider;

            public MacFactory(String macAlgorithmName) {
                this(macAlgorithmName, null);
            }

            public MacFactory(String macAlgorithmName, Provider provider) {
                this.algorithmName = macAlgorithmName;
                this.provider = provider;
            }

            @Override
            public HFunction createInstance() {
                try {
                    Mac mac = this.provider == null ? Mac.getInstance(this.algorithmName) : Mac.getInstance(this.algorithmName, this.provider);
                    return new HFunction.MacHFunction(mac);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("defined mac algorithm was not found", e);
                }
            }

            @Override
            public String getDescription() {
                return "MAC[" + this.algorithmName + "]";
            }
        }

        public static final class DigestFactory
        implements HFunctionFactory {
            private final String algorithmName;
            private final Provider provider;

            public DigestFactory(String messageDigestAlgorithmName) {
                this(messageDigestAlgorithmName, null);
            }

            public DigestFactory(String messageDigestAlgorithmName, Provider provider) {
                this.algorithmName = messageDigestAlgorithmName;
                this.provider = provider;
            }

            @Override
            public HFunction createInstance() {
                try {
                    MessageDigest messageDigest = this.provider == null ? MessageDigest.getInstance(this.algorithmName) : MessageDigest.getInstance(this.algorithmName, this.provider);
                    return new HFunction.MessageDigestHFunction(messageDigest);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("defined message digest algorithm was not found", e);
                }
            }

            @Override
            public String getDescription() {
                return "MessageDigest[" + this.algorithmName + "]";
            }
        }
    }
}

