/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.HFunction;
import at.favre.lib.crypto.HFunctionFactory;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class SingleStepKdf {
    private static SingleStepKdf singleStepKdfSha256;
    private static SingleStepKdf singleStepKdfHmacSha256;
    private final HFunctionFactory digestFactory;

    public static SingleStepKdf fromSha256() {
        if (singleStepKdfSha256 == null) {
            singleStepKdfSha256 = SingleStepKdf.from(HFunctionFactory.Default.sha256());
        }
        return singleStepKdfSha256;
    }

    public static SingleStepKdf fromSha512() {
        return SingleStepKdf.from(HFunctionFactory.Default.sha512());
    }

    public static SingleStepKdf fromHmacSha256() {
        if (singleStepKdfHmacSha256 == null) {
            singleStepKdfHmacSha256 = SingleStepKdf.from(HFunctionFactory.Default.hmacSha256());
        }
        return singleStepKdfHmacSha256;
    }

    public static SingleStepKdf fromHmacSha512() {
        return SingleStepKdf.from(HFunctionFactory.Default.hmacSha512());
    }

    public static SingleStepKdf from(HFunctionFactory factory) {
        return new SingleStepKdf(factory);
    }

    private SingleStepKdf(HFunctionFactory digestFactory) {
        this.digestFactory = Objects.requireNonNull(digestFactory, "digestFactory");
    }

    public String getHFunctionDescription() {
        return this.digestFactory.getDescription();
    }

    public byte[] derive(byte[] sharedSecretZ, int outLengthBytes) {
        return this.derive(sharedSecretZ, outLengthBytes, null, new byte[0]);
    }

    public byte[] derive(byte[] sharedSecretZ, int outLengthBytes, byte[] fixedInfo) {
        return this.derive(sharedSecretZ, outLengthBytes, null, fixedInfo);
    }

    public byte[] derive(byte[] sharedSecretZ, int outLengthBytes, byte[] salt, byte[] fixedInfo) {
        Objects.requireNonNull(sharedSecretZ, "sharedSecretZ");
        Objects.requireNonNull(fixedInfo, "fixedInfo");
        this.checkOutLength(outLengthBytes);
        HFunction digest = this.digestFactory.createInstance();
        int hashLengthBytes = digest.getHFuncOutputBytes();
        int counter = 1;
        int outputLenSum = 0;
        if (digest.requireInit()) {
            digest.init(salt);
        } else if (salt != null) {
            throw new IllegalArgumentException("Used h-function does not require a salt and none should be provided. You may include it in the fixedInfo parameter.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(outLengthBytes);
        int reps = (int)Math.ceil((float)outLengthBytes / (float)hashLengthBytes);
        do {
            digest.reset();
            digest.update(Bytes.from((int)counter).array());
            digest.update(sharedSecretZ);
            digest.update(fixedInfo);
            buffer.put(digest.calculate(), 0, reps == counter ? outLengthBytes - outputLenSum : hashLengthBytes);
            outputLenSum += hashLengthBytes;
        } while (counter++ < reps);
        return buffer.array();
    }

    private void checkOutLength(long outLengthByte) {
        if (outLengthByte == 0L) {
            throw new IllegalArgumentException("outLength must be greater 0");
        }
    }
}

