/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public interface HFunction {
    public void init(byte[] var1);

    public boolean requireInit();

    public int getHFuncOutputBytes();

    public void update(byte[] var1);

    public byte[] calculate();

    public void reset();

    public static final class MacHFunction
    implements HFunction {
        private final Mac mac;

        public MacHFunction(Mac mac) {
            this.mac = Objects.requireNonNull(mac, "mac");
        }

        @Override
        public void init(byte[] key) {
            if (key == null) {
                key = new byte[this.getHFuncOutputBytes()];
            }
            try {
                this.mac.init(new SecretKeySpec(key, this.mac.getAlgorithm()));
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException("invalid key", e);
            }
        }

        @Override
        public boolean requireInit() {
            return true;
        }

        @Override
        public int getHFuncOutputBytes() {
            return this.mac.getMacLength();
        }

        @Override
        public void update(byte[] array) {
            this.mac.update(array);
        }

        @Override
        public byte[] calculate() {
            return this.mac.doFinal();
        }

        @Override
        public void reset() {
            this.mac.reset();
        }
    }

    public static final class MessageDigestHFunction
    implements HFunction {
        private final MessageDigest digest;

        public MessageDigestHFunction(MessageDigest digest) {
            this.digest = Objects.requireNonNull(digest, "digest");
        }

        @Override
        public void init(byte[] key) {
            throw new UnsupportedOperationException("message digest does not support keying");
        }

        @Override
        public boolean requireInit() {
            return false;
        }

        @Override
        public int getHFuncOutputBytes() {
            return this.digest.getDigestLength();
        }

        @Override
        public void update(byte[] array) {
            this.digest.update(array);
        }

        @Override
        public byte[] calculate() {
            return this.digest.digest();
        }

        @Override
        public void reset() {
            this.digest.reset();
        }
    }
}

