/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesValidator;
import at.favre.lib.bytes.BytesValidators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;

public interface KeyManager {
    public static final int MIN_KEY_LENGTH_BYTE = 12;
    public static final int MAX_KEY_LENGTH_BYTE = 64;

    public IdSecretKey getById(int var1);

    public IdSecretKey getActiveKey();

    public int getActiveKeyId();

    public int size();

    public void clear();

    public static final class IdSecretKey {
        private final int keyId;
        private final byte[] keyBytes;

        public IdSecretKey(int keyId, byte[] keyBytes) {
            Bytes bytes = Bytes.wrap((byte[])keyBytes);
            if (!bytes.validate(new BytesValidator[]{BytesValidators.and((BytesValidator[])new BytesValidator[]{BytesValidators.atLeast((int)12), BytesValidators.atMost((int)64), BytesValidators.notOnlyOf((byte)0)})}) || bytes.entropy() < 2.5) {
                throw new IllegalArgumentException("key must be at least 8 byte, at most 64 byte and must not only contain zeros, also must have high entropy");
            }
            if (keyId < 0 || keyId > 15) {
                throw new IllegalArgumentException("key id must be between 0 and 15");
            }
            this.keyId = keyId;
            this.keyBytes = keyBytes;
        }

        public int getKeyId() {
            return this.keyId;
        }

        public byte[] getKeyBytes() {
            return this.keyBytes;
        }

        public void clear() {
            Bytes.wrap((byte[])this.keyBytes).mutable().secureWipe();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdSecretKey idSecretKey = (IdSecretKey)o;
            return this.keyId == idSecretKey.keyId && Arrays.equals(this.keyBytes, idSecretKey.keyBytes);
        }

        public int hashCode() {
            int result = Objects.hash(this.keyId);
            result = 31 * result + Arrays.hashCode(this.keyBytes);
            return result;
        }
    }

    public static final class CachedKdfConverter
    implements KeyManager {
        private final Map<Integer, byte[]> cache;
        private final KeyManager keyManager;
        private final KdfConverter converter;

        static KeyManager wrap(KeyManager keyManager, KdfConverter converter) {
            return new CachedKdfConverter(keyManager, converter);
        }

        CachedKdfConverter(KeyManager keyManager, KdfConverter converter) {
            this.keyManager = Objects.requireNonNull(keyManager, "keyManager");
            this.converter = Objects.requireNonNull(converter, "converter");
            this.cache = new HashMap<Integer, byte[]>(keyManager.size());
        }

        @Override
        public IdSecretKey getById(int id) {
            if (!this.cache.containsKey(id)) {
                IdSecretKey k = this.keyManager.getById(id);
                if (k != null) {
                    this.cache.put(id, this.converter.convert(k));
                } else {
                    return null;
                }
            }
            return new IdSecretKey(id, this.cache.get(id));
        }

        @Override
        public IdSecretKey getActiveKey() {
            return this.getById(this.getActiveKeyId());
        }

        @Override
        public int getActiveKeyId() {
            return this.keyManager.getActiveKeyId();
        }

        @Override
        public int size() {
            return this.keyManager.size();
        }

        @Override
        public void clear() {
            this.keyManager.clear();
        }

        public static interface KdfConverter {
            public byte[] convert(IdSecretKey var1);
        }
    }

    public static final class Default
    implements KeyManager {
        private final Map<Integer, IdSecretKey> keys = new HashMap<Integer, IdSecretKey>(3);
        private final int activeKeyId;

        Default(IdSecretKey activeKey, IdSecretKey ... moreKeys) {
            this.activeKeyId = Objects.requireNonNull(activeKey, "activeKey").keyId;
            ArrayList<IdSecretKey> list = new ArrayList<IdSecretKey>(1 + (moreKeys != null ? moreKeys.length : 0));
            list.add(activeKey);
            if (moreKeys != null) {
                list.addAll(Arrays.asList(moreKeys));
            }
            for (IdSecretKey idSecretKey : list) {
                if (this.keys.containsKey(idSecretKey.keyId)) {
                    throw new IllegalArgumentException("key with id " + idSecretKey.keyId + " already added");
                }
                this.keys.put(idSecretKey.keyId, Objects.requireNonNull(idSecretKey, "idSecretKey " + idSecretKey.keyId));
            }
        }

        @Override
        public IdSecretKey getById(int id) {
            return this.keys.get(id);
        }

        @Override
        public IdSecretKey getActiveKey() {
            return this.keys.get(this.getActiveKeyId());
        }

        @Override
        public int getActiveKeyId() {
            return this.activeKeyId;
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        @Override
        public void clear() {
            for (IdSecretKey value : this.keys.values()) {
                value.clear();
            }
            this.keys.clear();
        }
    }

    public static final class Factory {
        public static final int DEFAULT_KEY_ID = 0;

        private Factory() {
        }

        public static KeyManager with(IdSecretKey activeKey) {
            return new Default(activeKey, new IdSecretKey[0]);
        }

        public static KeyManager with(int id, byte[] secretKey) {
            return new Default(new IdSecretKey(id, secretKey), new IdSecretKey[0]);
        }

        public static KeyManager with(byte[] secretKey) {
            return new Default(new IdSecretKey(0, secretKey), new IdSecretKey[0]);
        }

        public static KeyManager with(SecretKey secretAesKey) {
            return Factory.with(secretAesKey.getEncoded());
        }

        public static KeyManager withKeyAndLegacyKeys(IdSecretKey activeKey, IdSecretKey ... legacyKeys) {
            return new Default(activeKey, Objects.requireNonNull(legacyKeys, "legacyKeys"));
        }

        static KeyManager withRandom() {
            return Factory.with(Bytes.random((int)16).array());
        }
    }
}

