/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.idmask.Config;
import at.favre.lib.idmask.IdMask;
import at.favre.lib.idmask.LongTuple;
import java.math.BigInteger;
import java.util.UUID;

public final class IdMasks {
    private IdMasks() {
    }

    public static IdMask<Long> forLongIds(Config config) {
        return new IdMask.LongIdMask(config);
    }

    public static IdMask<LongTuple> forLongTuples(Config config) {
        return new IdMask.LongIdTupleMask(config);
    }

    public static IdMask<UUID> forUuids(Config config) {
        return new IdMask.UuidMask(config);
    }

    public static IdMask<byte[]> for128bitNumbers(Config config) {
        return new IdMask.ByteArray128bitMask(config);
    }

    public static IdMask<BigInteger> forBigInteger(Config config) {
        return new IdMask.BigIntegerIdMask(config);
    }
}

