/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.HKDF;
import at.favre.lib.idmask.ByteToTextEncoding;
import at.favre.lib.idmask.IdMaskSecurityException;
import at.favre.lib.idmask.KeyManager;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public interface IdMaskEngine {
    public static final int MAX_ENGINE_ID = 15;
    public static final int MAX_KEY_ID = 15;

    public CharSequence mask(byte[] var1);

    public byte[] unmask(CharSequence var1);

    public static final class SixteenByteEngine
    extends BaseEngine
    implements IdMaskEngine {
        private static final String ALGORITHM = "AES/CBC/NoPadding";
        private static final String HMAC_ALGORITHM = "HmacSHA256";
        private static final int MAC_LENGTH_SHORT = 8;
        private static final int MAC_LENGTH_LONG = 16;
        private static final int ENGINE_ID = 1;
        private final boolean highSecurityMode;
        private ThreadLocal<Mac> macThreadLocal = new ThreadLocal();

        SixteenByteEngine(KeyManager keyManager) {
            this(keyManager, false, new ByteToTextEncoding.Base64Url(), new SecureRandom(), null, false, false);
        }

        public SixteenByteEngine(KeyManager keyManager, boolean highSecurityMode, ByteToTextEncoding encoding, SecureRandom secureRandom, Provider provider, boolean randomizeIds, boolean autoWipeMemory) {
            super(16, keyManager, provider, secureRandom, encoding, randomizeIds, autoWipeMemory);
            this.highSecurityMode = highSecurityMode;
        }

        @Override
        public CharSequence mask(byte[] plainId) {
            String string;
            block7: {
                Objects.requireNonNull(plainId, "id");
                if (plainId.length != this.getSupportedIdByteLength()) {
                    throw new IllegalArgumentException(String.format("id length must be between 1 and %d bytes", this.getSupportedIdByteLength()));
                }
                byte[] entropy = null;
                byte[] keys = null;
                byte[] currentKey = null;
                byte[] macKey = null;
                byte[] encryptedId = null;
                byte[] mac = null;
                try {
                    entropy = this.getEntropyBytes(this.getSupportedIdByteLength());
                    keys = this.hkdf.expand(this.getCurrentIdKey(), entropy, 64);
                    currentKey = Bytes.from((byte[])keys, (int)0, (int)16).array();
                    byte[] iv = Bytes.from((byte[])keys, (int)16, (int)16).array();
                    macKey = Bytes.from((byte[])keys, (int)32, (int)32).array();
                    Cipher cipher = this.getCipher();
                    cipher.init(1, (Key)new SecretKeySpec(currentKey, "AES"), new IvParameterSpec(iv));
                    encryptedId = cipher.doFinal(Bytes.from((byte[])plainId).xor(entropy).array());
                    byte version = this.createVersionByte((byte)this.keyManager.getActiveKeyId(), encryptedId);
                    mac = Bytes.from((byte[])this.macCipherText(macKey, encryptedId, iv, new byte[]{version}), (int)0, (int)this.getMacLength()).array();
                    ByteBuffer bb = ByteBuffer.allocate(1 + encryptedId.length + mac.length + (this.randomizeIds ? entropy.length : 0));
                    bb.put(version);
                    if (this.randomizeIds) {
                        bb.put(entropy);
                    }
                    bb.put(encryptedId);
                    bb.put(mac);
                    string = this.encoding.encode(bb.array());
                    if (!this.autoWipeMemory) break block7;
                }
                catch (Exception e) {
                    try {
                        throw new IllegalStateException(e);
                    }
                    catch (Throwable throwable) {
                        if (this.autoWipeMemory) {
                            Bytes.wrapNullSafe((byte[])entropy).mutable().secureWipe();
                            Bytes.wrapNullSafe(keys).mutable().secureWipe();
                            Bytes.wrapNullSafe(currentKey).mutable().secureWipe();
                            Bytes.wrapNullSafe(macKey).mutable().secureWipe();
                            Bytes.wrapNullSafe(encryptedId).mutable().secureWipe();
                            Bytes.wrapNullSafe(mac).mutable().secureWipe();
                        }
                        throw throwable;
                    }
                }
                Bytes.wrapNullSafe((byte[])entropy).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])keys).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])currentKey).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])macKey).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])encryptedId).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])mac).mutable().secureWipe();
            }
            return string;
        }

        /*
         * Loose catch block
         */
        @Override
        public byte[] unmask(CharSequence maskedId) {
            byte[] byArray;
            byte[] refMac;
            byte[] mac;
            byte[] cipherText;
            byte[] macKey;
            byte[] iv;
            byte[] currentKey;
            byte[] keys;
            block8: {
                this.checkInput(maskedId);
                ByteBuffer bb = ByteBuffer.wrap(this.encoding.decode(maskedId));
                this.checkDecodedLength(bb.remaining());
                keys = null;
                currentKey = null;
                iv = null;
                macKey = null;
                cipherText = null;
                mac = null;
                refMac = null;
                byte version = bb.get();
                byte[] entropy = this.getEntropyBytes(this.getSupportedIdByteLength());
                if (this.randomizeIds) {
                    bb.get(entropy);
                }
                cipherText = new byte[this.getSupportedIdByteLength()];
                bb.get(cipherText);
                mac = new byte[this.getMacLength()];
                bb.get(mac);
                byte[] currentSecretKey = this.checkAndGetCurrentKey(version, cipherText);
                keys = this.hkdf.expand(currentSecretKey, entropy, 64);
                currentKey = Bytes.from((byte[])keys, (int)0, (int)16).array();
                iv = Bytes.from((byte[])keys, (int)16, (int)16).array();
                macKey = Bytes.from((byte[])keys, (int)32, (int)32).array();
                refMac = Bytes.from((byte[])this.macCipherText(macKey, cipherText, iv, new byte[]{version}), (int)0, (int)this.getMacLength()).array();
                if (!Bytes.wrap((byte[])mac).equalsConstantTime(refMac)) {
                    throw new IdMaskSecurityException("mac does not match", IdMaskSecurityException.Reason.AUTH_TAG_DOES_NOT_MATCH_OR_INVALID_KEY);
                }
                Cipher cipher = this.getCipher();
                cipher.init(2, (Key)new SecretKeySpec(currentKey, "AES"), new IvParameterSpec(iv));
                byArray = Bytes.wrap((byte[])cipher.doFinal(cipherText)).xor(entropy).array();
                if (!this.autoWipeMemory) break block8;
                Bytes.wrapNullSafe((byte[])cipherText).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])mac).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])keys).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])currentKey).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])iv).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])macKey).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])refMac).mutable().secureWipe();
            }
            return byArray;
            {
                catch (Exception e) {
                    try {
                        throw new IllegalStateException(e);
                    }
                    catch (Throwable throwable) {
                        if (this.autoWipeMemory) {
                            Bytes.wrapNullSafe(cipherText).mutable().secureWipe();
                            Bytes.wrapNullSafe(mac).mutable().secureWipe();
                            Bytes.wrapNullSafe(keys).mutable().secureWipe();
                            Bytes.wrapNullSafe(currentKey).mutable().secureWipe();
                            Bytes.wrapNullSafe(iv).mutable().secureWipe();
                            Bytes.wrapNullSafe(macKey).mutable().secureWipe();
                            Bytes.wrapNullSafe(refMac).mutable().secureWipe();
                        }
                        throw throwable;
                    }
                }
            }
        }

        private void checkDecodedLength(int size) {
            int expectedLength = 1 + this.getSupportedIdByteLength() + (this.randomizeIds ? this.getSupportedIdByteLength() : 0) + this.getMacLength();
            if (size != expectedLength) {
                throw new IllegalArgumentException("unexpected message id length " + size + " - expected " + expectedLength);
            }
        }

        private int getMacLength() {
            return this.highSecurityMode ? 16 : 8;
        }

        private byte[] macCipherText(byte[] rawEncryptionKey, byte[] cipherText, byte[] iv, byte[] associatedData) {
            SecretKey macKey = this.createMacKey(rawEncryptionKey);
            try {
                Mac hmac = this.createHmacInstance();
                hmac.init(macKey);
                hmac.update(iv);
                hmac.update(cipherText);
                if (associatedData != null) {
                    hmac.update(associatedData);
                }
                return hmac.doFinal();
            }
            catch (InvalidKeyException e) {
                throw new IllegalStateException("error during HMAC calculation");
            }
        }

        private SecretKey createMacKey(byte[] rawEncryptionKey) {
            byte[] derivedMacKey = HKDF.fromHmacSha256().expand(rawEncryptionKey, Bytes.from((CharSequence)"macKey").array(), 32);
            return new SecretKeySpec(derivedMacKey, HMAC_ALGORITHM);
        }

        private synchronized Mac createHmacInstance() {
            Mac mac = this.macThreadLocal.get();
            if (mac == null) {
                try {
                    mac = this.provider != null ? Mac.getInstance(HMAC_ALGORITHM, this.provider) : Mac.getInstance(HMAC_ALGORITHM);
                }
                catch (Exception e) {
                    throw new IllegalStateException("could not get cipher instance", e);
                }
                this.macThreadLocal.set(mac);
                return this.macThreadLocal.get();
            }
            return mac;
        }

        @Override
        protected String getCipherAlgorithm() {
            return ALGORITHM;
        }

        @Override
        protected byte engineId() {
            return 1;
        }
    }

    public static final class EightByteEncryptionEngine
    extends BaseEngine
    implements IdMaskEngine {
        private static final String ALGORITHM = "AES/ECB/NoPadding";
        private static final int ENGINE_ID = 0;

        EightByteEncryptionEngine(KeyManager keyManager) {
            this(keyManager, null, new SecureRandom(), new ByteToTextEncoding.Base64Url(), false, false);
        }

        public EightByteEncryptionEngine(KeyManager keyManager, Provider provider, SecureRandom secureRandom, ByteToTextEncoding encoding, boolean randomizeIds, boolean autoWipeMemory) {
            super(8, keyManager, provider, secureRandom, encoding, randomizeIds, autoWipeMemory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public CharSequence mask(byte[] plainId) {
            String string;
            ByteBuffer bb;
            byte[] cipherText;
            byte[] message;
            byte[] random;
            block11: {
                if (plainId.length != this.getSupportedIdByteLength()) {
                    throw new IllegalArgumentException("input must be 8 byte long");
                }
                random = null;
                message = null;
                cipherText = null;
                random = this.getEntropyBytes(this.getSupportedIdByteLength());
                message = Bytes.wrap((byte[])random).append(plainId).array();
                SecretKeySpec secretKey = new SecretKeySpec(Bytes.from((byte[])this.getCurrentIdKey(), (int)0, (int)16).array(), "AES");
                Cipher c = this.getCipher();
                c.init(1, secretKey);
                cipherText = c.doFinal(message);
                byte version = this.createVersionByte((byte)this.keyManager.getActiveKeyId(), cipherText);
                if (this.randomizeIds) {
                    bb = ByteBuffer.allocate(1 + random.length + cipherText.length);
                    bb.put(version);
                    bb.put(random);
                    bb.put(cipherText);
                } else {
                    bb = ByteBuffer.allocate(1 + cipherText.length);
                    bb.put(version);
                    bb.put(cipherText);
                }
                string = this.encoding.encode(bb.array());
                Bytes.wrap((byte[])bb.array()).mutable().secureWipe();
                if (!this.autoWipeMemory) break block11;
                Bytes.wrapNullSafe((byte[])random).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])message).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])cipherText).mutable().secureWipe();
            }
            return string;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            Bytes.wrap((byte[])bb.array()).mutable().secureWipe();
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (this.autoWipeMemory) {
                            Bytes.wrapNullSafe((byte[])random).mutable().secureWipe();
                            Bytes.wrapNullSafe((byte[])message).mutable().secureWipe();
                            Bytes.wrapNullSafe(cipherText).mutable().secureWipe();
                        }
                        throw throwable2;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] unmask(CharSequence maskedId) {
            byte[] byArray;
            block8: {
                this.checkInput(maskedId);
                ByteBuffer bb = ByteBuffer.wrap(this.encoding.decode(maskedId));
                if (bb.remaining() != 1 + (this.randomizeIds ? 3 : 2) * this.getSupportedIdByteLength()) {
                    throw new IllegalArgumentException("unexpected message id length " + bb.remaining());
                }
                byte[] entropyData = null;
                byte[] cipherText = null;
                byte[] message = null;
                byte version = bb.get();
                try {
                    entropyData = this.getEntropyBytes(this.getSupportedIdByteLength());
                    if (this.randomizeIds) {
                        bb.get(entropyData);
                    }
                    cipherText = new byte[bb.remaining()];
                    bb.get(cipherText);
                    byte[] currentSecretKey = this.checkAndGetCurrentKey(version, cipherText);
                    try {
                        SecretKeySpec secretKey = new SecretKeySpec(Bytes.from((byte[])currentSecretKey, (int)0, (int)16).array(), "AES");
                        Cipher c = this.getCipher();
                        c.init(2, secretKey);
                        message = c.doFinal(cipherText);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    if (!Bytes.from((byte[])message, (int)0, (int)this.getSupportedIdByteLength()).equalsConstantTime(entropyData)) {
                        throw new IdMaskSecurityException("internal reference entropy does not match, probably forgery attempt or incorrect key", IdMaskSecurityException.Reason.AUTH_TAG_DOES_NOT_MATCH_OR_INVALID_KEY);
                    }
                    byArray = Bytes.from((byte[])message, (int)8, (int)this.getSupportedIdByteLength()).array();
                    if (!this.autoWipeMemory) break block8;
                }
                catch (Throwable throwable) {
                    if (this.autoWipeMemory) {
                        Bytes.wrapNullSafe((byte[])entropyData).mutable().secureWipe();
                        Bytes.wrapNullSafe((byte[])cipherText).mutable().secureWipe();
                        Bytes.wrapNullSafe(message).mutable().secureWipe();
                    }
                    throw throwable;
                }
                Bytes.wrapNullSafe((byte[])entropyData).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])cipherText).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])message).mutable().secureWipe();
            }
            return byArray;
        }

        @Override
        protected String getCipherAlgorithm() {
            return ALGORITHM;
        }

        @Override
        protected byte engineId() {
            return 0;
        }
    }

    public static abstract class BaseEngine {
        static int MAX_MASKED_ID_ENCODED_LENGTH = 768;
        static int MIN_MASKED_ID_ENCODED_LENGTH = 8;
        private ThreadLocal<Cipher> cipherWrapper = new ThreadLocal();
        final Provider provider;
        final SecureRandom secureRandom;
        final ByteToTextEncoding encoding;
        final HKDF hkdf = HKDF.fromHmacSha512();
        final KeyManager keyManager;
        final boolean randomizeIds;
        final boolean autoWipeMemory;
        final int supportedIdByteLength;

        BaseEngine(int supportedIdByteLength, KeyManager keyManager, Provider provider, SecureRandom secureRandom, ByteToTextEncoding encoding, boolean randomizeIds, boolean autoWipeMemory) {
            this.provider = provider;
            this.secureRandom = Objects.requireNonNull(secureRandom, "secureRandom");
            this.encoding = Objects.requireNonNull(encoding, "encoding");
            this.keyManager = KeyManager.CachedKdfConverter.wrap(keyManager, new KeyManager.CachedKdfConverter.KdfConverter(){

                @Override
                public byte[] convert(KeyManager.IdSecretKey original) {
                    return BaseEngine.this.hkdf.extract(Bytes.from((int)original.getKeyId()).array(), original.getKeyBytes());
                }
            });
            this.randomizeIds = randomizeIds;
            this.autoWipeMemory = autoWipeMemory;
            this.supportedIdByteLength = supportedIdByteLength;
        }

        protected abstract String getCipherAlgorithm();

        protected abstract byte engineId();

        int getSupportedIdByteLength() {
            return this.supportedIdByteLength;
        }

        byte[] getEntropyBytes(int size) {
            if (this.randomizeIds) {
                byte[] rnd = new byte[size];
                this.secureRandom.nextBytes(rnd);
                return rnd;
            }
            return Bytes.allocate((int)size).array();
        }

        synchronized Cipher getCipher() {
            Cipher cipher = this.cipherWrapper.get();
            if (cipher == null) {
                try {
                    cipher = this.provider != null ? Cipher.getInstance(this.getCipherAlgorithm(), this.provider) : Cipher.getInstance(this.getCipherAlgorithm());
                }
                catch (Exception e) {
                    throw new IllegalStateException("could not get cipher instance", e);
                }
                this.cipherWrapper.set(cipher);
                return this.cipherWrapper.get();
            }
            return cipher;
        }

        void checkInput(CharSequence maskedId) {
            if (Objects.requireNonNull(maskedId, "maskedId").length() > MAX_MASKED_ID_ENCODED_LENGTH || maskedId.length() < MIN_MASKED_ID_ENCODED_LENGTH) {
                throw new IllegalArgumentException("encoded masked id too long or short, must be between " + MIN_MASKED_ID_ENCODED_LENGTH + " and " + MAX_MASKED_ID_ENCODED_LENGTH + " chars");
            }
        }

        byte createVersionByte(byte keyId, byte[] cipherText) {
            byte engineId = this.engineId();
            if (keyId < 0 || keyId > 15 || engineId < 0 || engineId > 15) {
                throw new IllegalArgumentException("key and engine id must can only be 4 bit long");
            }
            return Bytes.from((byte)keyId).leftShift(4).or(Bytes.from((byte)engineId)).xor(Bytes.from((byte[])cipherText, (int)0, (int)1)).toByte();
        }

        byte getKeyIdFromVersion(byte obfuscatedVersion, byte[] cipherText) {
            return Bytes.from((byte)obfuscatedVersion).xor(Bytes.from((byte[])cipherText, (int)0, (int)1)).rightShift(4).and(Bytes.from((byte)15)).toByte();
        }

        byte getEngineIdFromVersion(byte obfuscatedVersion, byte[] cipherText) {
            return Bytes.from((byte)obfuscatedVersion).xor(Bytes.from((byte[])cipherText, (int)0, (int)1)).and(Bytes.from((byte)15)).toByte();
        }

        byte[] getCurrentIdKey() {
            return this.keyManager.getActiveKey().getKeyBytes();
        }

        byte[] getKeyForId(byte keyId) {
            KeyManager.IdSecretKey key = this.keyManager.getById(keyId);
            if (key == null) {
                return null;
            }
            return key.getKeyBytes();
        }

        byte[] checkAndGetCurrentKey(byte version, byte[] cipherText) {
            byte versionEngineId = this.getEngineIdFromVersion(version, cipherText);
            if (versionEngineId != this.engineId()) {
                throw new IdMaskSecurityException("wrong idMask engine used according to version byte - expected '" + this.engineId() + "' got '" + versionEngineId + "'", IdMaskSecurityException.Reason.UNKNOWN_ENGINE_ID);
            }
            byte keyId = this.getKeyIdFromVersion(version, cipherText);
            byte[] currentSecretKey = this.getKeyForId(keyId);
            if (currentSecretKey == null) {
                throw new IdMaskSecurityException("unknown key id '" + keyId + "'", IdMaskSecurityException.Reason.UNKNOWN_KEY_ID);
            }
            return currentSecretKey;
        }
    }
}

