/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.idmask.Config;
import at.favre.lib.idmask.IdMaskEngine;
import at.favre.lib.idmask.LongTuple;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.UUID;

public interface IdMask<T> {
    public String mask(T var1);

    public T unmask(String var1);

    public static final class BigIntegerIdMask
    extends BaseIdMask
    implements IdMask<BigInteger> {
        private static final int SUPPORTED_LENGTH = 15;

        BigIntegerIdMask(Config config) {
            super(new IdMaskEngine.SixteenByteEngine(config.keyManager(), config.highSecurityMode(), config.encoding(), config.secureRandom(), config.securityProvider(), config.randomizedIds(), config.autoWipeMemory()), config);
        }

        @Override
        public String mask(BigInteger id) {
            Bytes bytes = Bytes.from((BigInteger)id);
            if (bytes.length() > 15) {
                throw new IllegalArgumentException("biginteger only support up to 15 byte two-complements representation");
            }
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.put((byte)bytes.length());
            bb.put(bytes.resize(15).array());
            return this._encode(bb.array());
        }

        @Override
        public BigInteger unmask(String encoded) {
            ByteBuffer bb = ByteBuffer.wrap(this._decode(encoded));
            byte length = bb.get();
            byte[] number = new byte[bb.remaining()];
            bb.get(number);
            return Bytes.wrap((byte[])number).resize((int)length).toBigInteger();
        }
    }

    public static final class ByteArray128bitMask
    extends BaseIdMask
    implements IdMask<byte[]> {
        ByteArray128bitMask(Config config) {
            super(new IdMaskEngine.SixteenByteEngine(config.keyManager(), config.highSecurityMode(), config.encoding(), config.secureRandom(), config.securityProvider(), config.randomizedIds(), config.autoWipeMemory()), config);
        }

        @Override
        public String mask(byte[] id) {
            return this._encode(Bytes.from((byte[])id).array());
        }

        @Override
        public byte[] unmask(String encoded) {
            return this._decode(encoded);
        }
    }

    public static final class UuidMask
    extends BaseIdMask
    implements IdMask<UUID> {
        UuidMask(Config config) {
            super(new IdMaskEngine.SixteenByteEngine(config.keyManager(), config.highSecurityMode(), config.encoding(), config.secureRandom(), config.securityProvider(), config.randomizedIds(), config.autoWipeMemory()), config);
        }

        @Override
        public String mask(UUID id) {
            return this._encode(Bytes.from((UUID)id).array());
        }

        @Override
        public UUID unmask(String encoded) {
            byte[] out = this._decode(encoded);
            return Bytes.wrap((byte[])out).toUUID();
        }
    }

    public static final class LongIdTupleMask
    extends BaseIdMask
    implements IdMask<LongTuple> {
        LongIdTupleMask(Config config) {
            super(new IdMaskEngine.SixteenByteEngine(config.keyManager(), config.highSecurityMode(), config.encoding(), config.secureRandom(), config.securityProvider(), config.randomizedIds(), config.autoWipeMemory()), config);
        }

        @Override
        public String mask(LongTuple id) {
            return this._encode(Bytes.from((long[])new long[]{id.getNum1(), id.getNum2()}).array());
        }

        @Override
        public LongTuple unmask(String encoded) {
            Bytes out = Bytes.wrap((byte[])this._decode(encoded));
            return new LongTuple(out.longAt(0), out.longAt(8));
        }
    }

    public static final class LongIdMask
    extends BaseIdMask
    implements IdMask<Long> {
        LongIdMask(Config config) {
            super(new IdMaskEngine.EightByteEncryptionEngine(config.keyManager(), config.securityProvider(), config.secureRandom(), config.encoding(), config.randomizedIds(), config.autoWipeMemory()), config);
        }

        @Override
        public String mask(Long id) {
            return this._encode(Bytes.from((long)id).array());
        }

        @Override
        public Long unmask(String encoded) {
            byte[] out = this._decode(encoded);
            return Bytes.wrap((byte[])out).toLong();
        }
    }

    public static abstract class BaseIdMask {
        private final IdMaskEngine engine;
        private final Config config;

        BaseIdMask(IdMaskEngine engine, Config config) {
            this.engine = engine;
            this.config = config;
        }

        String _encode(byte[] id) {
            String encoded;
            if (this.config.enableCache() && !this.config.randomizedIds() && (encoded = this.config.cacheImpl().getEncoded(id)) != null) {
                return encoded;
            }
            encoded = this.engine.mask(id).toString();
            if (this.config.enableCache()) {
                this.config.cacheImpl().cache(id, encoded);
            }
            return encoded;
        }

        byte[] _decode(String encoded) {
            byte[] raw;
            if (this.config.enableCache() && !this.config.randomizedIds() && (raw = this.config.cacheImpl().getBytes(encoded)) != null) {
                return Bytes.wrap((byte[])raw).copy().array();
            }
            raw = this.engine.unmask(encoded);
            if (this.config.enableCache()) {
                this.config.cacheImpl().cache(raw, encoded);
            }
            return raw;
        }
    }
}

