/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.idmask.AutoValue_Config;
import at.favre.lib.idmask.ByteToTextEncoding;
import at.favre.lib.idmask.Cache;
import at.favre.lib.idmask.KeyManager;
import com.google.auto.value.AutoValue;
import java.security.Provider;
import java.security.SecureRandom;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class Config {
    abstract ByteToTextEncoding encoding();

    abstract boolean randomizedIds();

    abstract boolean highSecurityMode();

    abstract KeyManager keyManager();

    @Nullable
    abstract Provider securityProvider();

    abstract SecureRandom secureRandom();

    abstract Cache cacheImpl();

    abstract boolean enableCache();

    abstract boolean autoWipeMemory();

    public static Builder builder(KeyManager keyManager) {
        return new AutoValue_Config.Builder().keyManager(keyManager).encoding(new ByteToTextEncoding.Base64Url()).highSecurityMode(false).randomizedIds(false).securityProvider(null).cacheImpl(new Cache.SimpleLruMemCache()).enableCache(true).autoWipeMemory(false).secureRandom(new SecureRandom());
    }

    public static Builder builder(byte[] key) {
        return Config.builder(KeyManager.Factory.with(key));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder keyManager(KeyManager var1);

        public abstract Builder encoding(ByteToTextEncoding var1);

        public abstract Builder highSecurityMode(boolean var1);

        public abstract Builder randomizedIds(boolean var1);

        public abstract Builder securityProvider(Provider var1);

        public abstract Builder secureRandom(SecureRandom var1);

        public abstract Builder cacheImpl(Cache var1);

        public abstract Builder enableCache(boolean var1);

        public abstract Builder autoWipeMemory(boolean var1);

        public abstract Config build();
    }
}

