/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.bytes.Bytes;
import net.markenwerk.utils.lrucache.LruCache;

public interface Cache {
    public void cache(byte[] var1, String var2);

    public String getEncoded(byte[] var1);

    public byte[] getBytes(String var1);

    public void clear();

    public static final class SimpleLruMemCache
    implements Cache {
        private static final int CACHE_SIZE = 256;
        private final LruCache<CharSequence, String> lruCacheEncode;
        private final LruCache<CharSequence, byte[]> lruCacheDecode;

        public SimpleLruMemCache() {
            this(256);
        }

        public SimpleLruMemCache(int size) {
            this.lruCacheEncode = new LruCache(size);
            this.lruCacheDecode = new LruCache(size);
        }

        @Override
        public void cache(byte[] originalId, String encoded) {
            this.lruCacheEncode.put((Object)Bytes.wrap((byte[])originalId).hashSha256().encodeBase64(), (Object)encoded);
            this.lruCacheDecode.put((Object)encoded, (Object)originalId);
        }

        @Override
        public String getEncoded(byte[] originalId) {
            return (String)this.lruCacheEncode.get((Object)Bytes.wrap((byte[])originalId).hashSha256().encodeBase64());
        }

        @Override
        public byte[] getBytes(String encoded) {
            return (byte[])this.lruCacheDecode.get((Object)encoded);
        }

        @Override
        public void clear() {
            this.lruCacheDecode.clear();
            this.lruCacheEncode.clear();
        }
    }
}

