/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.idmask.BaseEncoding;
import java.util.Objects;
import java.util.regex.Pattern;

public interface ByteToTextEncoding {
    public String encode(byte[] var1);

    public byte[] decode(CharSequence var1);

    public static final class IdFormatter
    implements ByteToTextEncoding {
        private final ByteToTextEncoding byteToTextEncoding;
        private static final String SEPARATOR = "-";
        private static final int INTERVAL = 4;
        private final int currentInterval;
        private final String currentSeparator;

        public static IdFormatter wrap(ByteToTextEncoding byteToTextEncoding) {
            return new IdFormatter(byteToTextEncoding, 4, SEPARATOR);
        }

        public static IdFormatter wrap(ByteToTextEncoding byteToTextEncoding, int interval) {
            return new IdFormatter(byteToTextEncoding, interval, SEPARATOR);
        }

        public static IdFormatter wrap(ByteToTextEncoding byteToTextEncoding, int interval, String separator) {
            return new IdFormatter(byteToTextEncoding, interval, separator);
        }

        IdFormatter(ByteToTextEncoding byteToTextEncoding, int currentInterval, String currentSeparator) {
            this.byteToTextEncoding = Objects.requireNonNull(byteToTextEncoding, "byteToTextEncoding");
            this.currentInterval = currentInterval;
            this.currentSeparator = Objects.requireNonNull(currentSeparator, "separator");
            if (currentInterval < 2) {
                throw new IllegalArgumentException("interval must be at least 2");
            }
            if (currentSeparator.length() < 1 || currentSeparator.length() > 6) {
                throw new IllegalArgumentException("separator must be between 1 and 6 chars long");
            }
        }

        @Override
        public String encode(byte[] bytes) {
            return this.format(this.byteToTextEncoding.encode(bytes));
        }

        @Override
        public byte[] decode(CharSequence encoded) {
            return this.byteToTextEncoding.decode(encoded.toString().replaceAll(Pattern.quote(this.currentSeparator), ""));
        }

        private String format(String unformatted) {
            if (unformatted.length() < this.currentInterval * 2 - 1) {
                return unformatted;
            }
            if (unformatted.contains(this.currentSeparator)) {
                throw new IllegalArgumentException("Current separator '" + this.currentSeparator + "' can be found in the encoding of the id '" + unformatted + "' - please choose different one.");
            }
            StringBuilder sb = new StringBuilder();
            int remainingLength = unformatted.length();
            boolean even = true;
            while (remainingLength > 0) {
                int interval = even ? this.currentInterval : this.currentInterval + 2;
                int startIndex = unformatted.length() - remainingLength;
                if (remainingLength < interval) {
                    sb.append(unformatted, startIndex, unformatted.length());
                    remainingLength = 0;
                } else {
                    sb.append(unformatted, startIndex, startIndex + interval);
                    if ((remainingLength -= interval) != 0) {
                        sb.append(this.currentSeparator);
                    }
                }
                even = !even;
            }
            return sb.toString();
        }
    }

    public static final class Base16
    implements ByteToTextEncoding {
        @Override
        public String encode(byte[] bytes) {
            return Bytes.wrap((byte[])bytes).encodeHex();
        }

        @Override
        public byte[] decode(CharSequence encoded) {
            return Bytes.parseHex((CharSequence)encoded).array();
        }
    }

    public static class Base32Rfc4648
    extends BaseMod8Encoding {
        public Base32Rfc4648() {
            super("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray(), null);
        }
    }

    public static class CleanBase32Encoding
    extends BaseMod8Encoding {
        public CleanBase32Encoding() {
            super("abeknpqrwxyzBDEGKMPRVXYZ23456789".toCharArray(), null);
        }
    }

    public static class BaseMod8Encoding
    implements ByteToTextEncoding {
        private final BaseEncoding encoding;

        public BaseMod8Encoding(char[] alphabet, Character paddingChar) {
            int alphabetLength = alphabet.length;
            if (alphabetLength != 16 && alphabetLength != 32 && alphabetLength != 64) {
                throw new IllegalArgumentException("only alphabet length with 16, 32 or 64 supported");
            }
            this.encoding = new BaseEncoding(new BaseEncoding.Alphabet(alphabet), paddingChar);
        }

        @Override
        public String encode(byte[] bytes) {
            return this.encoding.encode(bytes);
        }

        @Override
        public byte[] decode(CharSequence encoded) {
            return this.encoding.decode(encoded);
        }
    }

    public static final class Base64Url
    implements ByteToTextEncoding {
        @Override
        public String encode(byte[] bytes) {
            return Bytes.wrap((byte[])bytes).encodeBase64(true, false);
        }

        @Override
        public byte[] decode(CharSequence encoded) {
            return Bytes.parseBase64((CharSequence)encoded).array();
        }
    }
}

