/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.idmask;

import at.favre.lib.idmask.ByteToTextEncoding;
import at.favre.lib.idmask.Cache;
import at.favre.lib.idmask.Config;
import at.favre.lib.idmask.KeyManager;
import java.security.Provider;
import java.security.SecureRandom;
import org.jetbrains.annotations.Nullable;

final class AutoValue_Config
extends Config {
    private final ByteToTextEncoding encoding;
    private final boolean randomizedIds;
    private final boolean highSecurityMode;
    private final KeyManager keyManager;
    private final Provider securityProvider;
    private final SecureRandom secureRandom;
    private final Cache cacheImpl;
    private final boolean enableCache;
    private final boolean autoWipeMemory;

    private AutoValue_Config(ByteToTextEncoding encoding, boolean randomizedIds, boolean highSecurityMode, KeyManager keyManager, @Nullable Provider securityProvider, SecureRandom secureRandom, Cache cacheImpl, boolean enableCache, boolean autoWipeMemory) {
        this.encoding = encoding;
        this.randomizedIds = randomizedIds;
        this.highSecurityMode = highSecurityMode;
        this.keyManager = keyManager;
        this.securityProvider = securityProvider;
        this.secureRandom = secureRandom;
        this.cacheImpl = cacheImpl;
        this.enableCache = enableCache;
        this.autoWipeMemory = autoWipeMemory;
    }

    @Override
    ByteToTextEncoding encoding() {
        return this.encoding;
    }

    @Override
    boolean randomizedIds() {
        return this.randomizedIds;
    }

    @Override
    boolean highSecurityMode() {
        return this.highSecurityMode;
    }

    @Override
    KeyManager keyManager() {
        return this.keyManager;
    }

    @Override
    @Nullable
    Provider securityProvider() {
        return this.securityProvider;
    }

    @Override
    SecureRandom secureRandom() {
        return this.secureRandom;
    }

    @Override
    Cache cacheImpl() {
        return this.cacheImpl;
    }

    @Override
    boolean enableCache() {
        return this.enableCache;
    }

    @Override
    boolean autoWipeMemory() {
        return this.autoWipeMemory;
    }

    public String toString() {
        return "Config{encoding=" + this.encoding + ", " + "randomizedIds=" + this.randomizedIds + ", " + "highSecurityMode=" + this.highSecurityMode + ", " + "keyManager=" + this.keyManager + ", " + "securityProvider=" + this.securityProvider + ", " + "secureRandom=" + this.secureRandom + ", " + "cacheImpl=" + this.cacheImpl + ", " + "enableCache=" + this.enableCache + ", " + "autoWipeMemory=" + this.autoWipeMemory + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Config) {
            Config that = (Config)o;
            return this.encoding.equals(that.encoding()) && this.randomizedIds == that.randomizedIds() && this.highSecurityMode == that.highSecurityMode() && this.keyManager.equals(that.keyManager()) && (this.securityProvider == null ? that.securityProvider() == null : this.securityProvider.equals(that.securityProvider())) && this.secureRandom.equals(that.secureRandom()) && this.cacheImpl.equals(that.cacheImpl()) && this.enableCache == that.enableCache() && this.autoWipeMemory == that.autoWipeMemory();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.encoding.hashCode();
        h$ *= 1000003;
        h$ ^= this.randomizedIds ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.highSecurityMode ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.keyManager.hashCode();
        h$ *= 1000003;
        h$ ^= this.securityProvider == null ? 0 : this.securityProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.secureRandom.hashCode();
        h$ *= 1000003;
        h$ ^= this.cacheImpl.hashCode();
        h$ *= 1000003;
        h$ ^= this.enableCache ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.autoWipeMemory ? 1231 : 1237;
    }

    static final class Builder
    extends Config.Builder {
        private ByteToTextEncoding encoding;
        private Boolean randomizedIds;
        private Boolean highSecurityMode;
        private KeyManager keyManager;
        private Provider securityProvider;
        private SecureRandom secureRandom;
        private Cache cacheImpl;
        private Boolean enableCache;
        private Boolean autoWipeMemory;

        Builder() {
        }

        @Override
        public Config.Builder encoding(ByteToTextEncoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("Null encoding");
            }
            this.encoding = encoding;
            return this;
        }

        @Override
        public Config.Builder randomizedIds(boolean randomizedIds) {
            this.randomizedIds = randomizedIds;
            return this;
        }

        @Override
        public Config.Builder highSecurityMode(boolean highSecurityMode) {
            this.highSecurityMode = highSecurityMode;
            return this;
        }

        @Override
        Config.Builder keyManager(KeyManager keyManager) {
            if (keyManager == null) {
                throw new NullPointerException("Null keyManager");
            }
            this.keyManager = keyManager;
            return this;
        }

        @Override
        public Config.Builder securityProvider(Provider securityProvider) {
            this.securityProvider = securityProvider;
            return this;
        }

        @Override
        public Config.Builder secureRandom(SecureRandom secureRandom) {
            if (secureRandom == null) {
                throw new NullPointerException("Null secureRandom");
            }
            this.secureRandom = secureRandom;
            return this;
        }

        @Override
        public Config.Builder cacheImpl(Cache cacheImpl) {
            if (cacheImpl == null) {
                throw new NullPointerException("Null cacheImpl");
            }
            this.cacheImpl = cacheImpl;
            return this;
        }

        @Override
        public Config.Builder enableCache(boolean enableCache) {
            this.enableCache = enableCache;
            return this;
        }

        @Override
        public Config.Builder autoWipeMemory(boolean autoWipeMemory) {
            this.autoWipeMemory = autoWipeMemory;
            return this;
        }

        @Override
        public Config build() {
            String missing = "";
            if (this.encoding == null) {
                missing = missing + " encoding";
            }
            if (this.randomizedIds == null) {
                missing = missing + " randomizedIds";
            }
            if (this.highSecurityMode == null) {
                missing = missing + " highSecurityMode";
            }
            if (this.keyManager == null) {
                missing = missing + " keyManager";
            }
            if (this.secureRandom == null) {
                missing = missing + " secureRandom";
            }
            if (this.cacheImpl == null) {
                missing = missing + " cacheImpl";
            }
            if (this.enableCache == null) {
                missing = missing + " enableCache";
            }
            if (this.autoWipeMemory == null) {
                missing = missing + " autoWipeMemory";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Config(this.encoding, this.randomizedIds, this.highSecurityMode, this.keyManager, this.securityProvider, this.secureRandom, this.cacheImpl, this.enableCache, this.autoWipeMemory);
        }
    }
}

