

package at.favre.lib.idmask;

import java.security.Provider;
import java.security.SecureRandom;
import javax.annotation.Generated;
import org.jetbrains.annotations.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Config extends Config {

  private final ByteToTextEncoding encoding;

  private final boolean randomizedIds;

  private final boolean highSecurityMode;

  private final KeyManager keyManager;

  private final Provider securityProvider;

  private final SecureRandom secureRandom;

  private final Cache cacheImpl;

  private final boolean enableCache;

  private final boolean autoWipeMemory;

  private AutoValue_Config(
      ByteToTextEncoding encoding,
      boolean randomizedIds,
      boolean highSecurityMode,
      KeyManager keyManager,
      @Nullable Provider securityProvider,
      SecureRandom secureRandom,
      Cache cacheImpl,
      boolean enableCache,
      boolean autoWipeMemory) {
    this.encoding = encoding;
    this.randomizedIds = randomizedIds;
    this.highSecurityMode = highSecurityMode;
    this.keyManager = keyManager;
    this.securityProvider = securityProvider;
    this.secureRandom = secureRandom;
    this.cacheImpl = cacheImpl;
    this.enableCache = enableCache;
    this.autoWipeMemory = autoWipeMemory;
  }

  @Override
  ByteToTextEncoding encoding() {
    return encoding;
  }

  @Override
  boolean randomizedIds() {
    return randomizedIds;
  }

  @Override
  boolean highSecurityMode() {
    return highSecurityMode;
  }

  @Override
  KeyManager keyManager() {
    return keyManager;
  }

  @Nullable
  @Override
  Provider securityProvider() {
    return securityProvider;
  }

  @Override
  SecureRandom secureRandom() {
    return secureRandom;
  }

  @Override
  Cache cacheImpl() {
    return cacheImpl;
  }

  @Override
  boolean enableCache() {
    return enableCache;
  }

  @Override
  boolean autoWipeMemory() {
    return autoWipeMemory;
  }

  @Override
  public String toString() {
    return "Config{"
         + "encoding=" + encoding + ", "
         + "randomizedIds=" + randomizedIds + ", "
         + "highSecurityMode=" + highSecurityMode + ", "
         + "keyManager=" + keyManager + ", "
         + "securityProvider=" + securityProvider + ", "
         + "secureRandom=" + secureRandom + ", "
         + "cacheImpl=" + cacheImpl + ", "
         + "enableCache=" + enableCache + ", "
         + "autoWipeMemory=" + autoWipeMemory
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Config) {
      Config that = (Config) o;
      return this.encoding.equals(that.encoding())
          && this.randomizedIds == that.randomizedIds()
          && this.highSecurityMode == that.highSecurityMode()
          && this.keyManager.equals(that.keyManager())
          && (this.securityProvider == null ? that.securityProvider() == null : this.securityProvider.equals(that.securityProvider()))
          && this.secureRandom.equals(that.secureRandom())
          && this.cacheImpl.equals(that.cacheImpl())
          && this.enableCache == that.enableCache()
          && this.autoWipeMemory == that.autoWipeMemory();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= encoding.hashCode();
    h$ *= 1000003;
    h$ ^= randomizedIds ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= highSecurityMode ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= keyManager.hashCode();
    h$ *= 1000003;
    h$ ^= (securityProvider == null) ? 0 : securityProvider.hashCode();
    h$ *= 1000003;
    h$ ^= secureRandom.hashCode();
    h$ *= 1000003;
    h$ ^= cacheImpl.hashCode();
    h$ *= 1000003;
    h$ ^= enableCache ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= autoWipeMemory ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends Config.Builder {
    private ByteToTextEncoding encoding;
    private Boolean randomizedIds;
    private Boolean highSecurityMode;
    private KeyManager keyManager;
    private Provider securityProvider;
    private SecureRandom secureRandom;
    private Cache cacheImpl;
    private Boolean enableCache;
    private Boolean autoWipeMemory;
    Builder() {
    }
    @Override
    public Config.Builder encoding(ByteToTextEncoding encoding) {
      if (encoding == null) {
        throw new NullPointerException("Null encoding");
      }
      this.encoding = encoding;
      return this;
    }
    @Override
    public Config.Builder randomizedIds(boolean randomizedIds) {
      this.randomizedIds = randomizedIds;
      return this;
    }
    @Override
    public Config.Builder highSecurityMode(boolean highSecurityMode) {
      this.highSecurityMode = highSecurityMode;
      return this;
    }
    @Override
    Config.Builder keyManager(KeyManager keyManager) {
      if (keyManager == null) {
        throw new NullPointerException("Null keyManager");
      }
      this.keyManager = keyManager;
      return this;
    }
    @Override
    public Config.Builder securityProvider(Provider securityProvider) {
      this.securityProvider = securityProvider;
      return this;
    }
    @Override
    public Config.Builder secureRandom(SecureRandom secureRandom) {
      if (secureRandom == null) {
        throw new NullPointerException("Null secureRandom");
      }
      this.secureRandom = secureRandom;
      return this;
    }
    @Override
    public Config.Builder cacheImpl(Cache cacheImpl) {
      if (cacheImpl == null) {
        throw new NullPointerException("Null cacheImpl");
      }
      this.cacheImpl = cacheImpl;
      return this;
    }
    @Override
    public Config.Builder enableCache(boolean enableCache) {
      this.enableCache = enableCache;
      return this;
    }
    @Override
    public Config.Builder autoWipeMemory(boolean autoWipeMemory) {
      this.autoWipeMemory = autoWipeMemory;
      return this;
    }
    @Override
    public Config build() {
      String missing = "";
      if (this.encoding == null) {
        missing += " encoding";
      }
      if (this.randomizedIds == null) {
        missing += " randomizedIds";
      }
      if (this.highSecurityMode == null) {
        missing += " highSecurityMode";
      }
      if (this.keyManager == null) {
        missing += " keyManager";
      }
      if (this.secureRandom == null) {
        missing += " secureRandom";
      }
      if (this.cacheImpl == null) {
        missing += " cacheImpl";
      }
      if (this.enableCache == null) {
        missing += " enableCache";
      }
      if (this.autoWipeMemory == null) {
        missing += " autoWipeMemory";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Config(
          this.encoding,
          this.randomizedIds,
          this.highSecurityMode,
          this.keyManager,
          this.securityProvider,
          this.secureRandom,
          this.cacheImpl,
          this.enableCache,
          this.autoWipeMemory);
    }
  }

}
