/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto;

import at.favre.lib.crypto.HkdfMacFactory;
import java.nio.ByteBuffer;
import javax.crypto.Mac;

public final class HKDF {
    private static HKDF hkdfHmacSha256;
    private static HKDF hkdfHmacSha512;
    private final HkdfMacFactory macFactory;

    private HKDF(HkdfMacFactory macFactory) {
        this.macFactory = macFactory;
    }

    public static HKDF fromHmacSha256() {
        if (hkdfHmacSha256 == null) {
            hkdfHmacSha256 = HKDF.from(HkdfMacFactory.Default.hmacSha256());
        }
        return hkdfHmacSha256;
    }

    public static HKDF fromHmacSha512() {
        if (hkdfHmacSha512 == null) {
            hkdfHmacSha512 = HKDF.from(HkdfMacFactory.Default.hmacSha512());
        }
        return hkdfHmacSha512;
    }

    public static HKDF from(HkdfMacFactory macFactory) {
        return new HKDF(macFactory);
    }

    public byte[] extract(byte[] inputKeyingMaterial, byte[] salt) {
        return new Extractor(this.macFactory).execute(inputKeyingMaterial, salt);
    }

    public byte[] expand(byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
        return new Expander(this.macFactory).execute(pseudoRandomKey, info, outLengthBytes);
    }

    public byte[] extractAndExpand(byte[] inputKeyingMaterial, byte[] saltExtract, byte[] infoExpand, int outLengthByte) {
        return new Expander(this.macFactory).execute(new Extractor(this.macFactory).execute(inputKeyingMaterial, saltExtract), infoExpand, outLengthByte);
    }

    HkdfMacFactory getMacFactory() {
        return this.macFactory;
    }

    static final class Expander {
        private final HkdfMacFactory macFactory;

        Expander(HkdfMacFactory macFactory) {
            this.macFactory = macFactory;
        }

        byte[] execute(byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
            if (outLengthBytes <= 0) {
                throw new IllegalArgumentException("out length bytes must be at least 1");
            }
            if (pseudoRandomKey == null || pseudoRandomKey.length <= 0) {
                throw new IllegalArgumentException("provided pseudoRandomKey must be at least of size 1 and not null");
            }
            Mac hmacHasher = this.macFactory.createInstance(pseudoRandomKey);
            if (info == null) {
                info = new byte[]{};
            }
            byte[] blockN = new byte[]{};
            int iterations = (int)Math.ceil((double)outLengthBytes / (double)hmacHasher.getMacLength());
            if (iterations > 255) {
                throw new IllegalArgumentException("out length must be maximal 255 * hash-length; requested: " + outLengthBytes + " bytes");
            }
            ByteBuffer buffer = ByteBuffer.allocate(outLengthBytes);
            int remainingBytes = outLengthBytes;
            for (int i = 0; i < iterations; ++i) {
                hmacHasher.update(blockN);
                hmacHasher.update(info);
                hmacHasher.update((byte)(i + 1));
                blockN = hmacHasher.doFinal();
                int stepSize = Math.min(remainingBytes, blockN.length);
                buffer.put(blockN, 0, stepSize);
                remainingBytes -= stepSize;
            }
            return buffer.array();
        }
    }

    static final class Extractor {
        private final HkdfMacFactory macFactory;

        Extractor(HkdfMacFactory macFactory) {
            this.macFactory = macFactory;
        }

        byte[] execute(byte[] inputKeyingMaterial, byte[] salt) {
            if (salt == null || salt.length == 0) {
                salt = new byte[this.macFactory.createInstance(new byte[1]).getMacLength()];
            }
            if (inputKeyingMaterial == null || inputKeyingMaterial.length <= 0) {
                throw new IllegalArgumentException("provided inputKeyingMaterial must be at least of size 1 and not null");
            }
            Mac mac = this.macFactory.createInstance(salt);
            mac.update(inputKeyingMaterial);
            return mac.doFinal();
        }
    }
}

