/*
 * Decompiled with CFR 0.152.
 */
package at.favre.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

interface HkdfMacFactory {
    public Mac createMacInstance(byte[] var1);

    public int macHashLengthByte();

    public static final class Default
    implements HkdfMacFactory {
        private final String macAlgorithmName;
        private final int hashLengthBytes;
        private final Provider provider;

        public static HkdfMacFactory hmacSha256() {
            return new Default("HmacSHA256", 32, null);
        }

        public static HkdfMacFactory hmacSha512() {
            return new Default("HmacSHA512", 64, null);
        }

        @Deprecated
        public static HkdfMacFactory hmacSha1() {
            return new Default("HmacSHA1", 20, null);
        }

        public Default(String macAlgorithmName, int hashLengthBytes) {
            this(macAlgorithmName, hashLengthBytes, null);
        }

        public Default(String macAlgorithmName, int hashLengthBytes, Provider provider) {
            this.macAlgorithmName = macAlgorithmName;
            this.hashLengthBytes = hashLengthBytes;
            this.provider = provider;
        }

        @Override
        public Mac createMacInstance(byte[] key) {
            try {
                SecretKeySpec secretKey = new SecretKeySpec(key, this.macAlgorithmName);
                Mac hmacInstance = this.provider == null ? Mac.getInstance(this.macAlgorithmName) : Mac.getInstance(this.macAlgorithmName, this.provider);
                hmacInstance.init(secretKey);
                return hmacInstance;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("defined mac algorithm was not found", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not make hmac hasher in hkdf", e);
            }
        }

        @Override
        public int macHashLengthByte() {
            return this.hashLengthBytes;
        }
    }
}

