/*
 * Decompiled with CFR 0.152.
 */
package at.favre.crypto;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

interface HkdfMacFactory {
    public Mac createMacInstance(byte[] var1);

    public int macHashLengthByte();

    public static class Default
    implements HkdfMacFactory {
        private final String macAlgorithmName;
        private final int hashLengthBytes;

        public static HkdfMacFactory hmacSha256() {
            return new Default("HmacSHA256", 32);
        }

        public static HkdfMacFactory hmacSha512() {
            return new Default("HmacSHA512", 64);
        }

        @Deprecated
        public static HkdfMacFactory hmacSha1() {
            return new Default("HmacSha1", 20);
        }

        Default(String macAlgorithmName, int hashLengthBytes) {
            this.macAlgorithmName = macAlgorithmName;
            this.hashLengthBytes = hashLengthBytes;
        }

        @Override
        public Mac createMacInstance(byte[] key) {
            try {
                SecretKeySpec secretKey = new SecretKeySpec(key, this.macAlgorithmName);
                Mac hmacHasher = Mac.getInstance(this.macAlgorithmName);
                hmacHasher.init(secretKey);
                return hmacHasher;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("defined mac algorithm was not found", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not make hmac hasher in hkdf", e);
            }
        }

        @Override
        public int macHashLengthByte() {
            return this.hashLengthBytes;
        }
    }
}

