/*
 * Decompiled with CFR 0.152.
 */
package at.favre.crypto;

import at.favre.crypto.HkdfMacFactory;
import java.io.ByteArrayOutputStream;
import javax.crypto.Mac;

public final class HKDF {
    private HKDF() {
    }

    public static byte[] extractHmacSha256(byte[] inputKeyingMaterial, byte[] salt) {
        return HKDF.extract(HkdfMacFactory.Default.hmacSha256(), inputKeyingMaterial, salt);
    }

    public static byte[] extractHmacSha512(byte[] inputKeyingMaterial, byte[] salt) {
        return HKDF.extract(HkdfMacFactory.Default.hmacSha512(), inputKeyingMaterial, salt);
    }

    public static byte[] extract(HkdfMacFactory macFactory, byte[] inputKeyingMaterial, byte[] salt) {
        return new Extractor(macFactory).hkdfExtract(inputKeyingMaterial, salt);
    }

    public static byte[] expandHmacSha256(byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
        return HKDF.expand(HkdfMacFactory.Default.hmacSha256(), pseudoRandomKey, info, outLengthBytes);
    }

    public static byte[] expandHmacSha512(byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
        return HKDF.expand(HkdfMacFactory.Default.hmacSha512(), pseudoRandomKey, info, outLengthBytes);
    }

    public static byte[] expand(HkdfMacFactory macFactory, byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
        return new Expander(macFactory).hkdfExpand(pseudoRandomKey, info, outLengthBytes);
    }

    public static byte[] hkdfSha256(byte[] inputKeyingMaterial, byte[] saltExtract, byte[] infoExpand, int outLengthByte) {
        return HKDF.hkdf(HkdfMacFactory.Default.hmacSha256(), inputKeyingMaterial, saltExtract, infoExpand, outLengthByte);
    }

    public static byte[] hkdf(HkdfMacFactory macFactory, byte[] inputKeyingMaterial, byte[] saltExtract, byte[] infoExpand, int outLengthByte) {
        return new Expander(macFactory).hkdfExpand(new Extractor(macFactory).hkdfExtract(inputKeyingMaterial, saltExtract), infoExpand, outLengthByte);
    }

    static final class Expander {
        private final HkdfMacFactory macFactory;

        Expander(HkdfMacFactory macFactory) {
            this.macFactory = macFactory;
        }

        byte[] hkdfExpand(byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
            if (outLengthBytes <= 0) {
                throw new IllegalArgumentException("out length bytes must be at least 1");
            }
            if (pseudoRandomKey == null || pseudoRandomKey.length <= 0) {
                throw new IllegalArgumentException("provided pseudoRandomKey must be at least of size 1 and not null");
            }
            Mac hmacHasher = this.macFactory.createMacInstance(pseudoRandomKey);
            if (info == null) {
                info = new byte[]{};
            }
            byte[] blockN = new byte[]{};
            int iterations = (int)Math.ceil((double)outLengthBytes / (double)this.macFactory.macHashLengthByte());
            if (iterations > 255) {
                throw new IllegalArgumentException("out length must be maximal 255 * hash len");
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream(outLengthBytes);
            int remainingBytes = outLengthBytes;
            for (int i = 0; i < iterations; ++i) {
                hmacHasher.update(blockN);
                hmacHasher.update(info);
                hmacHasher.update((byte)(i + 1));
                blockN = hmacHasher.doFinal();
                int stepSize = Math.min(remainingBytes, blockN.length);
                stream.write(blockN, 0, stepSize);
                remainingBytes -= stepSize;
            }
            return stream.toByteArray();
        }
    }

    static final class Extractor {
        private final HkdfMacFactory macFactory;

        Extractor(HkdfMacFactory macFactory) {
            this.macFactory = macFactory;
        }

        byte[] hkdfExtract(byte[] inputKeyingMaterial, byte[] salt) {
            if (salt == null || salt.length == 0) {
                salt = new byte[this.macFactory.macHashLengthByte()];
            }
            if (inputKeyingMaterial == null || inputKeyingMaterial.length <= 0) {
                throw new IllegalArgumentException("provided inputKeyingMaterial must be at least of size 1 and not null");
            }
            Mac mac = this.macFactory.createMacInstance(salt);
            mac.update(inputKeyingMaterial);
            return mac.doFinal();
        }
    }
}

