/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

final class Util {

    static final class BytesIterator
    implements Iterator<java.lang.Byte> {
        private final byte[] array;
        private int cursor = 0;

        /*
         * WARNING - void declaration
         */
        BytesIterator(byte[] array) {
            void var1_1;
            this.array = var1_1;
        }

        @Override
        public final boolean hasNext() {
            return this.cursor != this.array.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private java.lang.Byte next() {
            try {
                void var2_2;
                void var1_1;
                int i = this.cursor;
                java.lang.Byte next = this.array[i];
                this.cursor = var1_1 + true;
                return var2_2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("The Bytes iterator does not support removing");
        }
    }

    static final class File {
        /*
         * WARNING - void declaration
         */
        static byte[] readFromStream(InputStream inputStream, int maxLengthToRead) {
            boolean readWholeStream = maxLengthToRead == -1;
            try {
                int r;
                ByteArrayOutputStream out = new ByteArrayOutputStream(readWholeStream ? 32 : maxLengthToRead);
                byte[] buf = new byte[]{};
                for (int remaining = maxLengthToRead; readWholeStream || remaining > 0; remaining -= r) {
                    int bufSize = Math.min(4096, readWholeStream ? 4096 : remaining);
                    if (buf.length != bufSize) {
                        buf = new byte[bufSize];
                    }
                    if ((r = inputStream.read(buf)) == -1) break;
                    out.write(buf, 0, r);
                }
                return out.toByteArray();
            }
            catch (Exception e) {
                void var1_3;
                throw new IllegalStateException("could not read from input stream", (Throwable)var1_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        static byte[] readFromDataInput(DataInput dataInput, int length) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(length);
            try {
                void var2_2;
                int remaining = length;
                for (int i = 0; i < length; ++i) {
                    byte[] buf = new byte[Math.min(remaining, 4096)];
                    dataInput.readFully(buf);
                    out.write(buf);
                    remaining -= buf.length;
                }
                return var2_2.toByteArray();
            }
            catch (Exception e) {
                void var3_6;
                throw new IllegalStateException("could not read from data input", (Throwable)var3_6);
            }
        }

        /*
         * WARNING - void declaration
         */
        static byte[] readFromFile(java.io.File file) {
            Validation.access$000(file);
            try {
                return Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                void var0_1;
                throw new IllegalStateException("could not read from file", (Throwable)var0_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        static byte[] readFromFile(java.io.File file, int offset, int length) {
            byte[] byArray;
            Validation.access$000(file);
            RandomAccessFile raf2 = new RandomAccessFile(file, "r");
            Throwable throwable = null;
            try {
                void var2_7;
                void var1_3;
                raf2.seek((long)var1_3);
                byArray = File.readFromDataInput(raf2, (int)var2_7);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                raf2.close();
                            }
                            catch (Throwable raf2) {
                                throwable.addSuppressed(raf2);
                            }
                        } else {
                            raf2.close();
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    void var0_2;
                    throw new IllegalStateException("could not read from random access file", (Throwable)var0_2);
                }
            }
            raf2.close();
            return byArray;
        }
    }

    static final class Validation {
        /*
         * WARNING - void declaration
         */
        static void checkIndexBounds(int length, int index, int primitiveLength, String type) {
            int n;
            void var2_2;
            if (index < 0 || index + var2_2 > n) {
                void var1_1;
                void var3_3;
                throw new IndexOutOfBoundsException("cannot get " + (String)var3_3 + " from index out of bounds: " + (int)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        static void checkExactLength(int length, int expectedLength, String type) {
            if (length != expectedLength) {
                int n;
                void var1_1;
                void var2_2;
                throw new IllegalArgumentException("cannot convert to " + (String)var2_2 + " if length != " + (int)var1_1 + " bytes (was " + n + ")");
            }
        }

        /*
         * WARNING - void declaration
         */
        static void checkModLength(int length, int modFactor, String errorSubject) {
            if (length % modFactor != 0) {
                int n;
                void var1_1;
                void var2_2;
                throw new IllegalArgumentException("Illegal length for " + (String)var2_2 + ". Byte array length must be multiple of " + (int)var1_1 + ", length was " + n);
            }
        }

        static /* synthetic */ void access$000(java.io.File x0) {
            java.io.File file;
            if (x0 == null || !file.exists() || !file.isFile()) {
                throw new IllegalArgumentException("file must not be null, has to exist and must be a file (not a directory) ".concat(String.valueOf(file)));
            }
        }
    }

    static final class Obj {
        /*
         * WARNING - void declaration
         */
        static int hashCode(byte[] byteArray, ByteOrder byteOrder) {
            void var1_2;
            void var0_1;
            int result = Arrays.hashCode(byteArray);
            return 31 * var0_1 + (byteOrder != null ? var1_2.hashCode() : 0);
        }
    }

    static final class Converter {
        /*
         * WARNING - void declaration
         */
        static char[] byteToCharArray(byte[] bytes, Charset charset, ByteOrder byteOrder) {
            Objects.requireNonNull(bytes, "bytes must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            try {
                void var2_3;
                CharBuffer charBuffer = charset.newDecoder().decode(ByteBuffer.wrap(bytes).order((ByteOrder)var2_3));
                Object charBuffer2 = charBuffer;
                if (charBuffer.capacity() != ((Buffer)charBuffer2).limit()) {
                    void var1_2;
                    char[] compacted = new char[((Buffer)charBuffer2).remaining()];
                    ((CharBuffer)charBuffer2).get(compacted);
                    return var1_2;
                }
                return ((CharBuffer)charBuffer2).array();
            }
            catch (CharacterCodingException e) {
                void var0_1;
                throw new IllegalStateException((Throwable)var0_1);
            }
        }
    }

    static final class Byte {
        /*
         * WARNING - void declaration
         */
        static byte[] concat(byte[] ... arrays) {
            byte[][] byArray;
            int length = 0;
            byte[][] byArray2 = arrays;
            int n = arrays.length;
            for (int i = 0; i < n; ++i) {
                byte[] array = byArray2[i];
                length += array.length;
            }
            byte[] result = new byte[length];
            int pos = 0;
            byte[][] byArray3 = byArray;
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                void var1_3;
                byte[] array = byArray3[i];
                System.arraycopy(array, 0, result, pos, array.length);
                pos += ((void)var1_3).length;
            }
            return byArray2;
        }

        /*
         * WARNING - void declaration
         */
        static int indexOf(byte[] array, byte[] target, int start, int end) {
            void i;
            Objects.requireNonNull(array, "array must not be null");
            Objects.requireNonNull(target, "target must not be null");
            if (target.length == 0 || start < 0) {
                return -1;
            }
            while (i < Math.min(end, array.length - target.length + 1)) {
                block4: {
                    for (int j = 0; j < target.length; ++j) {
                        if (array[i + j] == target[j]) {
                            continue;
                        }
                        break block4;
                    }
                    return (int)i;
                }
                ++i;
            }
            return -1;
        }
    }
}

