/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesFactory;
import at.favre.lib.bytes.Util;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;

public final class MutableBytes
extends Bytes
implements AutoCloseable {
    /*
     * WARNING - void declaration
     */
    MutableBytes(byte[] byteArray, ByteOrder byteOrder) {
        super((byte[])var1_1, (ByteOrder)var2_2, new Factory(0));
        void var2_2;
        void var1_1;
    }

    public static MutableBytes allocate(int length) {
        return MutableBytes.allocate(length, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public static MutableBytes allocate(int length, byte defaultValue) {
        void var1_1;
        return Bytes.allocate(length, (byte)var1_1).mutable();
    }

    @Override
    public final boolean isMutable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes overwrite(byte[] newArray) {
        void var1_1;
        return this.overwrite((byte[])var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes overwrite(Bytes newBytes) {
        void var1_1;
        return this.overwrite((Bytes)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes overwrite(byte[] newArray, int offsetInternalArray) {
        void var1_1;
        void var2_2;
        Objects.requireNonNull(newArray, "must provide non-null array as source");
        System.arraycopy(newArray, 0, this.internalArray(), (int)var2_2, ((void)var1_1).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes overwrite(Bytes newBytes, int offsetInternalArray) {
        void var2_2;
        void var1_1;
        return this.overwrite(((Bytes)Objects.requireNonNull(var1_1, "must provide non-null array as source")).array(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes setByteAt(int index, byte newByte) {
        void var2_2;
        this.internalArray()[var1_1] = var2_2;
        return this;
    }

    public final MutableBytes wipe() {
        return this.fill((byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes fill(byte fillByte) {
        void var1_1;
        Arrays.fill(this.internalArray(), (byte)var1_1);
        return this;
    }

    public final MutableBytes secureWipe() {
        return this.secureWipe(new SecureRandom());
    }

    /*
     * WARNING - void declaration
     */
    public final MutableBytes secureWipe(SecureRandom random) {
        Objects.requireNonNull(random, "random param must not be null");
        if (this.length() > 0) {
            void var1_1;
            var1_1.nextBytes(this.internalArray());
        }
        return this;
    }

    public final Bytes immutable() {
        return Bytes.wrap(this.internalArray(), this.byteOrder());
    }

    @Override
    public final int hashCode() {
        return Util.Obj.hashCode(this.internalArray(), this.byteOrder());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object o) {
        void var1_1;
        return super.equals(var1_1);
    }

    @Override
    public final void close() {
        this.secureWipe();
    }

    private static final class Factory
    implements BytesFactory {
        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Bytes wrap(byte[] array, ByteOrder byteOrder) {
            void var2_2;
            void var1_1;
            return new MutableBytes((byte[])var1_1, (ByteOrder)var2_2);
        }

        /* synthetic */ Factory(byte by) {
            this();
        }
    }
}

